/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.rule.TypeDeclaration;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.PropertyChangeSupport;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.TypeSafe;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDeclarationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TypeDeclarationFactory.class);
    protected TypeDeclarationContext context;

    public TypeDeclarationFactory(TypeDeclarationContext context) {
        this.context = context;
    }

    public TypeDeclaration processTypeDeclaration(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr) {
        TypeDeclaration type = this.context.getTypeBuilder().getExistingTypeDeclaration(typeDescr.getFullTypeName());
        if (type == null) {
            type = new TypeDeclaration(typeDescr.getTypeName());
            type.setResource(typeDescr.getResource());
            Class<?> existingClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkgRegistry);
            type.setTypeClass(existingClass);
            type.setNovel(existingClass == null);
            type.setNature(existingClass == null ? TypeDeclaration.Nature.DEFINITION : TypeDeclaration.Nature.DECLARATION);
        }
        this.processTypeAnnotations(typeDescr, type);
        return type;
    }

    private void processTypeAnnotations(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type) {
        try {
            TypeDeclarationFactory.processAnnotations(typeDescr, type);
        }
        catch (Exception e) {
            this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, e.getMessage()));
        }
    }

    public static void processAnnotations(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type) {
        TypeSafe typeSafe;
        Role role = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)typeDescr, Role.class);
        if (role != null) {
            type.setRole(role.value());
        }
        if ((typeSafe = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)typeDescr, TypeSafe.class)) != null) {
            type.setTypesafe(typeSafe.value());
        }
        if (typeDescr instanceof EnumDeclarationDescr) {
            type.setKind(TypeDeclaration.Kind.ENUM);
        } else if (typeDescr instanceof TypeDeclarationDescr && ((TypeDeclarationDescr)typeDescr).isTrait()) {
            type.setKind(TypeDeclaration.Kind.TRAIT);
        }
        type.setDynamic(typeDescr.hasAnnotation(PropertyChangeSupport.class));
    }

    protected void checkRedeclaration(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry) {
        block15: {
            TypeDeclaration previousTypeDeclaration = this.context.getPackageRegistry(typeDescr.getNamespace()).getPackage().getTypeDeclaration(typeDescr.getTypeName());
            try {
                if (!type.isDefinition()) {
                    Class<?> existingDeclarationClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkgRegistry);
                    if (this.context.getBuilderConfiguration().isPreCompiled() || GeneratedFact.class.isAssignableFrom(existingDeclarationClass) || type.getTypeClassDef().getFields().isEmpty()) break block15;
                    try {
                        Class existingClass = pkgRegistry.getPackage().getTypeResolver().resolveType(typeDescr.getType().getFullName());
                        ClassFieldInspector cfi = CoreComponentsBuilder.get().createClassFieldInspector(existingClass);
                        int fieldCount = 0;
                        for (String existingFieldName : cfi.getFieldTypesField().keySet()) {
                            if (cfi.isNonGetter(existingFieldName) || "class".equals(existingFieldName) || !cfi.getSetterMethods().containsKey(existingFieldName) || !cfi.getGetterMethods().containsKey(existingFieldName)) continue;
                            if (!typeDescr.getFields().containsKey(existingFieldName)) {
                                type.setValid(false);
                                this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " does not include field " + existingFieldName));
                                continue;
                            }
                            String fldType = cfi.getFieldType(existingFieldName).getName();
                            fldType = TypeDeclarationUtils.toBuildableType(fldType, this.context.getRootClassLoader());
                            TypeFieldDescr declaredField = (TypeFieldDescr)typeDescr.getFields().get(existingFieldName);
                            if (!fldType.equals(type.getTypeClassDef().getField(existingFieldName).getTypeName())) {
                                type.setValid(false);
                                this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " redeclared field " + existingFieldName + " : \nexisting : " + fldType + " vs declared : " + declaredField.getPattern().getObjectType()));
                                continue;
                            }
                            ++fieldCount;
                        }
                        if (fieldCount != typeDescr.getFields().size()) {
                            this.context.addBuilderResult((KnowledgeBuilderResult)this.reportDeclarationDiff(cfi, typeDescr));
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        LOG.error("Exception", (Throwable)e);
                        type.setValid(false);
                        this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                    }
                    catch (ClassNotFoundException e) {
                        type.setValid(false);
                        this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                    }
                    break block15;
                }
                if (previousTypeDeclaration != null) {
                    int typeComparisonResult = this.compareTypeDeclarations(previousTypeDeclaration, type);
                    if (typeComparisonResult < 0) {
                        this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, typeDescr.getType().getFullName() + " declares more fields than the already existing version"));
                        type.setValid(false);
                    } else if (typeComparisonResult > 0 && !type.getTypeClassDef().getFields().isEmpty()) {
                        this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, typeDescr.getType().getFullName() + " declares less fields than the already existing version"));
                        type.setValid(false);
                    }
                    if (type.getNature() == TypeDeclaration.Nature.DECLARATION) {
                        this.mergeTypeDeclarations(previousTypeDeclaration, type);
                    }
                }
            }
            catch (IncompatibleClassChangeError error) {
                this.context.addBuilderResult((KnowledgeBuilderResult)new TypeDeclarationError((BaseDescr)typeDescr, error.getMessage()));
            }
        }
    }

    protected void mergeTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) {
        if (oldDeclaration == null) {
            return;
        }
        for (FieldDefinition oldFactField : oldDeclaration.getTypeClassDef().getFieldsDefinitions()) {
            FieldDefinition newFactField = newDeclaration.getTypeClassDef().getField(oldFactField.getName());
            if (newFactField != null) continue;
            newDeclaration.getTypeClassDef().addField(oldFactField);
        }
        newDeclaration.setTypeClass(oldDeclaration.getTypeClass());
    }

    protected int compareTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) throws IncompatibleClassChangeError {
        if (!oldDeclaration.getFormat().equals((Object)newDeclaration.getFormat())) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different format that its previous definition: " + newDeclaration.getFormat() + "!=" + oldDeclaration.getFormat());
        }
        if (!(oldDeclaration.getTypeClassDef().getSuperClass().equals(newDeclaration.getTypeClassDef().getSuperClass()) || oldDeclaration.getNature() == TypeDeclaration.Nature.DEFINITION && newDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION && Object.class.getName().equals(newDeclaration.getTypeClassDef().getSuperClass()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different superclass that its previous definition: " + newDeclaration.getTypeClassDef().getSuperClass() + " != " + oldDeclaration.getTypeClassDef().getSuperClass());
        }
        if (!this.nullSafeEqualityComparison((Comparable)((Object)oldDeclaration.getDurationAttribute()), (Comparable)((Object)newDeclaration.getDurationAttribute()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different duration: " + newDeclaration.getDurationAttribute() + " != " + oldDeclaration.getDurationAttribute());
        }
        if (newDeclaration.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && oldDeclaration.getSetMask() != newDeclaration.getSetMask()) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " is incompatible with the previous definition: " + newDeclaration + " != " + oldDeclaration);
        }
        List oldFields = oldDeclaration.getTypeClassDef().getFields();
        HashMap<String, FactField> newFieldsMap = new HashMap<String, FactField>();
        for (FactField factField : newDeclaration.getTypeClassDef().getFields()) {
            newFieldsMap.put(factField.getName(), factField);
        }
        boolean allFieldsInOldDeclarationAreStillPresent = true;
        for (FactField oldFactField : oldFields) {
            FactField newFactField = (FactField)newFieldsMap.get(oldFactField.getName());
            if (newFactField != null) {
                String newFactType = ((FieldDefinition)newFactField).getTypeName();
                if (newFactType.equals(((FieldDefinition)oldFactField).getTypeName())) continue;
                throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + "." + newFactField.getName() + " has a different type that its previous definition: " + newFactType + " != " + oldFactField.getType().getCanonicalName());
            }
            allFieldsInOldDeclarationAreStillPresent = false;
        }
        if (oldFields.size() < newFieldsMap.size()) {
            return -1;
        }
        if (oldFields.size() > newFieldsMap.size()) {
            return 1;
        }
        if (allFieldsInOldDeclarationAreStillPresent) {
            return 0;
        }
        throw new IncompatibleClassChangeError(newDeclaration.getTypeName() + " introduces fields that are not present in its previous version.");
    }

    protected boolean nullSafeEqualityComparison(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c2 != null && c1.compareTo(c2) == 0;
    }

    private TypeDeclarationError reportDeclarationDiff(ClassFieldInspector cfi, AbstractClassTypeDeclarationDescr typeDescr) {
        ArrayList<String> existing = new ArrayList<String>();
        for (String existingFieldName : cfi.getFieldTypesField().keySet()) {
            if (cfi.isNonGetter(existingFieldName) || "class".equals(existingFieldName) || !cfi.getSetterMethods().containsKey(existingFieldName)) continue;
            existing.add(existingFieldName);
        }
        Collections.sort(existing);
        ArrayList declared = new ArrayList(typeDescr.getFields().keySet());
        Collections.sort(declared);
        ArrayList<String> deltas = new ArrayList<String>();
        for (String s : existing) {
            if (declared.contains(s)) continue;
            deltas.add("--" + s);
        }
        for (String s : declared) {
            if (existing.contains(s)) continue;
            deltas.add("++" + s);
        }
        return new TypeDeclarationError((BaseDescr)typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " can't declare a different set of fields \nexisting : " + existing + "\ndeclared : " + declared + "\ndiff : " + deltas);
    }
}

