/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import org.dmg.pmml.pmml_4_2.descr.DATATYPE;
import org.dmg.pmml.pmml_4_2.descr.DataField;
import org.dmg.pmml.pmml_4_2.descr.MiningField;
import org.dmg.pmml.pmml_4_2.descr.OutputField;
import org.kie.pmml.pmml_4_2.PMML4Helper;

public class PMMLDataField {
    private String type;
    private String name;
    private DataField dataDictionaryField;
    private static PMML4Helper helper = new PMML4Helper();

    public PMMLDataField(String name, DATATYPE type) {
        this.name = name;
        this.type = helper.mapDatatype(type, true);
    }

    public PMMLDataField(MiningField miningField, DataField field) {
        this.name = miningField.getName();
        if (field != null) {
            this.type = helper.mapDatatype(field.getDataType(), true);
        }
        this.dataDictionaryField = field;
    }

    public PMMLDataField(OutputField outputField, DataField field) {
        this.name = outputField.getName();
        if (outputField.getDataType() != null) {
            this.type = helper.mapDatatype(outputField.getDataType(), true);
        } else if (field != null) {
            this.type = helper.mapDatatype(field.getDataType(), true);
        }
        this.dataDictionaryField = field;
    }

    public PMMLDataField(DataField field) {
        this.type = helper.mapDatatype(field.getDataType(), true);
        this.name = helper.compactAsJavaId(field.getName());
        this.dataDictionaryField = field;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompactUpperCaseName() {
        return helper.compactUpperCase(this.name);
    }

    public DataField getRawDataField() {
        return this.dataDictionaryField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PMMLDataField dataField = (PMMLDataField)o;
        if (this.getType() != null ? !this.getType().equals(dataField.getType()) : dataField.getType() != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(dataField.getName()) : dataField.getName() == null;
    }

    public int hashCode() {
        int result = this.getType() != null ? this.getType().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }
}

