/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.util.List;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegment;

public class MiningSegmentWeight {
    private String segmentationId;
    private String segmentId;
    private String targetName;
    private Double weight;
    private Number segmentValue;

    public MiningSegmentWeight(MiningSegment segment) {
        this.segmentationId = segment.getOwner().getSegmentationId();
        this.segmentId = segment.getSegmentId();
        List<String> targets = segment.getTargetsForWeighting();
        if (targets != null && !targets.isEmpty()) {
            this.targetName = targets.get(0);
        }
        this.weight = segment.getWeight();
    }

    public MiningSegmentWeight(String segmentationId, String segmentId, String targetName, Double weight) {
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
        this.targetName = targetName;
        this.weight = weight;
    }

    public String getSegmentationId() {
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Number getSegmentValue() {
        return this.segmentValue;
    }

    public Double getSegmentValueAsDouble() {
        return this.segmentValue != null ? Double.valueOf(this.segmentValue.doubleValue()) : null;
    }

    public void setSegmentValue(Number segmentValue) {
        this.segmentValue = segmentValue;
    }

    public Number getWeightedSegmentValue() {
        return this.segmentValue != null ? Double.valueOf(this.segmentValue.doubleValue() * this.weight) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.segmentId == null ? 0 : this.segmentId.hashCode());
        result = 31 * result + (this.segmentationId == null ? 0 : this.segmentationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiningSegmentWeight other = (MiningSegmentWeight)obj;
        if (this.segmentId == null ? other.segmentId != null : !this.segmentId.equals(other.segmentId)) {
            return false;
        }
        return !(this.segmentationId == null ? other.segmentationId != null : !this.segmentationId.equals(other.segmentationId));
    }

    public String toString() {
        return "MiningSegmentWeight [segmentationId=" + this.segmentationId + ", segmentId=" + this.segmentId + ", targetName=" + this.targetName + ", weight=" + this.weight + ", segmentValue=" + this.segmentValue + "]";
    }
}

