/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import org.drools.core.base.WrappedStatefulKnowledgeSessionForRHS;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.spi.KnowledgeHelper;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecutionState;

@PropertyReactive
public class SegmentExecution
implements Comparable<SegmentExecution> {
    private String correlationId;
    private String segmentationId;
    private String segmentId;
    private int segmentIndex;
    private SegmentExecutionState state;
    private String ruleUnitClassName;
    private PMMLRequestData requestData;
    private PMML4Result result;

    public SegmentExecution() {
    }

    public SegmentExecution(String correlationId, String segmentationId, String segmentId, int segmentIndex, String ruleUnitClassName) {
        this.correlationId = correlationId;
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
        this.segmentIndex = segmentIndex;
        this.state = SegmentExecutionState.WAITING;
        this.ruleUnitClassName = ruleUnitClassName;
    }

    public SegmentExecution(String correlationId, String segmentationId, String segmentId, int segmentIndex, String state, String ruleUnitClassName) {
        this.correlationId = correlationId;
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
        this.segmentIndex = segmentIndex;
        this.state = SegmentExecutionState.valueOf(state);
        this.ruleUnitClassName = ruleUnitClassName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getSegmentationId() {
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public SegmentExecutionState getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = SegmentExecutionState.valueOf(state);
    }

    public void setState(SegmentExecutionState state) {
        this.state = state;
    }

    public String getRuleUnitClassName() {
        return this.ruleUnitClassName;
    }

    public void setRuleUnitClassName(String ruleUnitClassName) {
        this.ruleUnitClassName = ruleUnitClassName;
    }

    public PMMLRequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(PMMLRequestData requestData) {
        this.requestData = requestData;
    }

    public PMML4Result getResult() {
        return this.result;
    }

    public void setResult(PMML4Result result) {
        this.result = result;
    }

    public void applySegmentModel(PMMLRequestData requestData, DataSource<PMMLRequestData> data, DataSource<PMML4Result> results, DataSource<SegmentExecution> segmentExecutions, KnowledgeHelper helper) throws IllegalStateException {
        if (this.ruleUnitClassName == null || this.ruleUnitClassName.trim().isEmpty()) {
            throw new IllegalStateException("Unable to apply segment model: No rule unit class name is available");
        }
        Class ruleUnitClass = null;
        RuleUnitDescriptionRegistry rur = ((KnowledgeBaseImpl)helper.getKieRuntime().getKieBase()).getRuleUnitDescriptionRegistry();
        RuleUnit ruOld = ((WrappedStatefulKnowledgeSessionForRHS)helper.getKieRuntime()).getRuleUnitExecutor().getCurrentRuleUnit();
        RuleUnitDescription rud = rur.getDescription(this.ruleUnitClassName).orElse(null);
        if (rud == null) {
            throw new IllegalStateException("Unable to apply segment model: Unable to find rule unit");
        }
        ruleUnitClass = rud.getRuleUnitClass();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.segmentId == null ? 0 : this.segmentId.hashCode());
        result = 31 * result + this.segmentIndex;
        result = 31 * result + (this.segmentationId == null ? 0 : this.segmentationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentExecution other = (SegmentExecution)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.segmentId == null ? other.segmentId != null : !this.segmentId.equals(other.segmentId)) {
            return false;
        }
        if (this.segmentIndex != other.segmentIndex) {
            return false;
        }
        return !(this.segmentationId == null ? other.segmentationId != null : !this.segmentationId.equals(other.segmentationId));
    }

    @Override
    public int compareTo(SegmentExecution segEx) {
        if (this.segmentIndex == segEx.segmentIndex) {
            return 0;
        }
        return this.segmentIndex > segEx.segmentIndex ? 1 : -1;
    }

    public class SegmentEventListener
    extends DefaultAgendaEventListener {
        public void matchCancelled(MatchCancelledEvent event) {
            System.out.println("Match cancelled - " + event.getCause().name() + " - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void matchCreated(MatchCreatedEvent event) {
            System.out.println("Match created - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
            System.out.println("After match fired - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }

        public void beforeMatchFired(BeforeMatchFiredEvent event) {
            System.out.println("Before match fired - " + event.getMatch().getRule().getPackageName() + " : " + event.getMatch().getRule().getName());
        }
    }
}

