/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class PropertyReference<T> {
    private Object instance;
    private String name;
    private Method getter;

    public PropertyReference(Object instance, String name) {
        this.instance = instance;
        this.name = name;
        try {
            PropertyDescriptor[] propDescrs;
            for (PropertyDescriptor propDescr : propDescrs = Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors()) {
                if (!propDescr.getName().equals(name)) continue;
                this.getter = propDescr.getReadMethod();
                break;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unable to create getter", e);
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        try {
            return (T)this.getter.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable read getter", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReference that = (PropertyReference)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.instance.equals(that.instance);
    }

    public int hashCode() {
        int result = this.instance.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "PropertyReference{instance=" + this.instance + ", name='" + this.name + '\'' + '}';
    }
}

