/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.info;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.marshalling.MarshallerWriteContext;
import org.drools.core.process.WorkItem;
import org.drools.core.process.impl.WorkItemImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.serialization.protobuf.ProtobufInputMarshaller;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.ProtobufOutputMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@SequenceGenerator(name="workItemInfoIdSeq", sequenceName="WORKITEMINFO_ID_SEQ")
public class WorkItemInfo
implements PersistentWorkItem {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemInfo.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="workItemInfoIdSeq")
    private Long workItemId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String name;
    private Date creationDate;
    private String processInstanceId;
    private long state;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] workItemByteArray;
    @Transient
    private WorkItem workItem;
    @Transient
    private Environment env;

    protected WorkItemInfo() {
    }

    public WorkItemInfo(WorkItem workItem, Environment env) {
        this.workItem = workItem;
        this.name = workItem.getName();
        this.creationDate = new Date();
        this.processInstanceId = workItem.getProcessInstanceId();
        this.env = env;
    }

    public Long getId() {
        return this.workItemId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public long getState() {
        return this.state;
    }

    public byte[] getWorkItemByteArray() {
        return this.workItemByteArray;
    }

    public WorkItem getWorkItem(Environment env, InternalKnowledgeBase kBase) {
        this.env = env;
        if (this.workItem == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.workItemByteArray);
                ProtobufMarshallerReaderContext context = new ProtobufMarshallerReaderContext((InputStream)bais, kBase, null, null, null, env);
                try {
                    this.workItem = ProtobufInputMarshaller.readWorkItem((MarshallerReaderContext)context);
                }
                catch (Exception e) {
                    try {
                        context.close();
                        bais = new ByteArrayInputStream(this.workItemByteArray);
                        context = new ProtobufMarshallerReaderContext((InputStream)bais, kBase, null, null, null, env);
                        this.workItem = WorkItemInfo.readWorkItem((MarshallerReaderContext)context);
                    }
                    catch (IOException e1) {
                        logger.error("Unable to read work item with InputMarshaller", (Throwable)e1);
                        throw new RuntimeException("Unable to read work item ", e);
                    }
                }
                context.close();
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
                throw new IllegalArgumentException("IOException while loading work item: " + e.getMessage());
            }
        }
        return this.workItem;
    }

    private static WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        ObjectInputStream stream = (ObjectInputStream)context;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readUTF());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    int index = stream.readInt();
                    ObjectMarshallingStrategy strategy = null;
                    if (index >= 0) {
                        strategy = context.getResolverStrategyFactory().getStrategy(index);
                        if (strategy == null) {
                            throw new IllegalStateException("No strategy of with index " + index + " available.");
                        }
                    } else if (index == -2) {
                        String strategyClassName = stream.readUTF();
                        if ("org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy".equals(strategyClassName)) {
                            strategyClassName = "org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy";
                        }
                        if ((strategy = context.getResolverStrategyFactory().getStrategyObject(strategyClassName)) == null) {
                            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                        }
                    } else {
                        throw new IllegalStateException("Wrong index of strategy field read: " + index + "!");
                    }
                    Object value = strategy.read(stream);
                    workItem.setParameter(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        return workItem;
    }

    public void transform() {
        this.state = this.workItem.getState();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ProtobufMarshallerWriteContext context = new ProtobufMarshallerWriteContext((OutputStream)baos, null, null, null, null, this.env);
            ProtobufOutputMarshaller.writeWorkItem((MarshallerWriteContext)context, (WorkItem)this.workItem);
            context.close();
            this.workItemByteArray = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing workItem " + this.workItem.getId() + ": " + e.getMessage());
        }
    }

    public void setId(Long id) {
        this.workItemId = id;
    }
}

