/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.consequence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.beliefsystem.Mode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.factmodel.traits.CoreWrapper;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Declaration;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.process.AbstractProcessContext;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.bitmask.BitMask;
import org.drools.kiesession.consequence.StatefulKnowledgeSessionForRHS;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    protected InternalMatch internalMatch;
    private Tuple tuple;
    protected ReteEvaluator reteEvaluator;
    private StatefulKnowledgeSessionForRHS wrappedEvaluator;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(ReteEvaluator reteEvaluator) {
        this.reteEvaluator = reteEvaluator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.internalMatch = (InternalMatch)in.readObject();
        this.tuple = (LeftTuple)in.readObject();
        this.reteEvaluator = (ReteEvaluator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.internalMatch);
        out.writeObject(this.tuple);
        out.writeObject(this.reteEvaluator);
    }

    public void setActivation(InternalMatch internalMatch) {
        this.internalMatch = internalMatch;
        this.tuple = internalMatch.getTuple();
    }

    public InternalMatch getActivation() {
        return this.internalMatch;
    }

    public void reset() {
        this.internalMatch = null;
        this.tuple = null;
    }

    public void blockMatch(Match act) {
        TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
    }

    public void unblockAllMatches(Match act) {
        TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
    }

    public FactHandle insertAsync(Object object) {
        return this.toStatefulKnowledgeSession().insertAsync(object);
    }

    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    public FactHandle insert(Object object, boolean dynamic) {
        return (InternalFactHandle)((InternalWorkingMemoryEntryPoint)this.reteEvaluator.getDefaultEntryPoint()).insert(object, dynamic, this.internalMatch.getRule(), (TerminalNode)this.internalMatch.getTuple().getTupleSink());
    }

    public FactHandle insertLogical(Object object, Mode belief) {
        return this.insertLogical(object, belief);
    }

    public FactHandle insertLogical(Object object, Mode ... beliefs) {
        return this.insertLogical(object, beliefs);
    }

    public FactHandle insertLogical(Object object) {
        return this.insertLogical(object, (Object)null);
    }

    public FactHandle insertLogical(Object object, Object value) {
        TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
        return null;
    }

    public FactHandle insertLogical(EntryPoint ep, Object object) {
        TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
        return null;
    }

    public InternalFactHandle bolster(Object object) {
        return this.bolster(object, null);
    }

    public InternalFactHandle bolster(Object object, Object value) {
        TruthMaintenanceSystemFactory.throwExceptionForMissingTms();
        return null;
    }

    public void cancelMatch(Match act) {
        InternalMatch match = (InternalMatch)act;
        ((RuleTerminalNode)match.getTerminalNode()).cancelMatch(match, this.reteEvaluator);
    }

    public FactHandle getFactHandle(Object object) {
        InternalFactHandle handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            if (object instanceof CoreWrapper) {
                handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
            }
            if (handle == null && this.reteEvaluator.getKnowledgeBase().getRuleBaseConfiguration().getAssertBehaviour() == RuleBaseConfiguration.AssertBehaviour.EQUALITY) {
                FactHandle modifiedFh = this.tuple.getFactHandle();
                while (modifiedFh == null || modifiedFh.getObject() != object) {
                    this.tuple = this.tuple.getParent();
                    modifiedFh = this.tuple.getFactHandle();
                }
                handle = modifiedFh;
            }
            if (handle == null) {
                throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
        }
        return handle;
    }

    public FactHandle getFactHandle(FactHandle handle) {
        InternalFactHandle handleFromWM = this.getFactHandleFromWM(handle.getObject());
        return handleFromWM != null ? handleFromWM : handle;
    }

    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        h.getEntryPoint(this.reteEvaluator).update((FactHandle)h, newObject, PropertySpecificUtil.onlyTraitBitSetMask(), newObject.getClass(), this.internalMatch);
    }

    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    public void update(FactHandle handle, BitMask mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint(this.reteEvaluator)).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.internalMatch);
        if (h.isTraitOrTraitable()) {
            this.toStatefulKnowledgeSession().updateTraits(h, mask, modifiedClass, this.internalMatch);
        }
    }

    public void update(Object object) {
        this.update(object, PropertySpecificUtil.allSetButTraitBitMask(), Object.class);
    }

    public void update(Object object, BitMask mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    public void retract(Object object) {
        this.delete(this.getFactHandle(object));
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(Object object) {
        this.delete(this.getFactHandle(object));
    }

    public void delete(Object object, FactHandle.State fhState) {
        this.delete(this.getFactHandle(object), fhState);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, FactHandle.State.ALL);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        Object o = ((InternalFactHandle)handle).getObject();
        if (((InternalFactHandle)handle).isTraiting()) {
            this.delete(((Thing)o).getCore());
            return;
        }
        ((InternalFactHandle)handle).getEntryPoint(this.reteEvaluator).delete(handle, this.internalMatch.getRule(), (TerminalNode)this.internalMatch.getTuple().getTupleSink(), fhState);
    }

    public RuleImpl getRule() {
        return this.internalMatch.getRule();
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public Declaration[] getRequiredDeclarations() {
        return ((RuleTerminalNode)this.tuple.getTupleSink()).getRequiredDeclarations();
    }

    public WorkingMemory getWorkingMemory() {
        return this.toStatefulKnowledgeSession();
    }

    public KieRuntime getKnowledgeRuntime() {
        return this.toStatefulKnowledgeSession();
    }

    public StatefulKnowledgeSessionForRHS toStatefulKnowledgeSession() {
        if (this.wrappedEvaluator != null) {
            return this.wrappedEvaluator;
        }
        if (this.reteEvaluator instanceof StatefulKnowledgeSessionImpl) {
            this.wrappedEvaluator = new StatefulKnowledgeSessionForRHS((StatefulKnowledgeSessionImpl)this.reteEvaluator);
            return this.wrappedEvaluator;
        }
        throw new UnsupportedOperationException("Operation not supported when using a lightweight session");
    }

    public InternalMatch getMatch() {
        return this.internalMatch;
    }

    public void setFocus(String focus) {
        this.toStatefulKnowledgeSession().setFocus(focus);
    }

    public Object get(Declaration declaration) {
        return declaration.getValue((ValueResolver)this.reteEvaluator, (BaseTuple)this.tuple);
    }

    public Declaration getDeclaration(String identifier) {
        return (Declaration)this.internalMatch.getTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    public void halt() {
        this.toStatefulKnowledgeSession().halt();
    }

    public EntryPoint getEntryPoint(String id) {
        return this.reteEvaluator.getEntryPoint(id);
    }

    public Channel getChannel(String id) {
        return this.toStatefulKnowledgeSession().getChannels().get(id);
    }

    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.toStatefulKnowledgeSession().getChannels());
    }

    protected InternalFactHandle getFactHandleFromWM(Object object) {
        return DefaultKnowledgeHelper.getFactHandleFromWM(this.reteEvaluator, object);
    }

    public static InternalFactHandle getFactHandleFromWM(ReteEvaluator reteEvaluator, Object object) {
        for (EntryPoint ep : reteEvaluator.getEntryPoints()) {
            InternalFactHandle handle = (InternalFactHandle)ep.getFactHandle(object);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    public <T> T getContext(Class<T> contextClass) {
        Map nodeInstances;
        String ruleflowGroupName;
        if (ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getMatch().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.toStatefulKnowledgeSession().getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.toStatefulKnowledgeSession().getProcessInstance((String)entry.getKey());
            AbstractProcessContext context = this.createProcessContext();
            context.setProcessInstance(processInstance);
            String nodeInstance = (String)entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (!this.sameNodeInstance(subNodeInstance, nodeInstanceIds[i])) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
            }
            return (T)context;
        }
        return null;
    }

    protected AbstractProcessContext createProcessContext() {
        return new org.drools.core.process.ProcessContext((KieRuntime)this.toStatefulKnowledgeSession().getKnowledgeRuntime());
    }

    protected boolean sameNodeInstance(NodeInstance subNodeInstance, String nodeInstanceId) {
        return subNodeInstance.getId().equals(nodeInstanceId);
    }

    public KieRuntime getKieRuntime() {
        return this.getKnowledgeRuntime();
    }

    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical, Mode ... modes) {
        return this.don(core.getCore(), trait, logical, modes);
    }

    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits) {
        return this.don(core, traits, false);
    }

    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, Mode ... modes) {
        return this.don(core, traits, true, modes);
    }

    public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical) {
        return this.don(core, traits, logical, null);
    }

    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        return this.don(core, trait, logical, null);
    }

    public <T, K> T don(K core, Class<T> trait, Mode ... modes) {
        return this.don(core, trait, true, modes);
    }

    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        return this.toStatefulKnowledgeSession().shed(this.internalMatch, core, trait);
    }

    private <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean b, Mode ... modes) {
        return this.toStatefulKnowledgeSession().don(this.internalMatch, core, traits, b, modes);
    }

    private <T, K> T don(K core, Class<T> trait, boolean b, Mode ... modes) {
        return this.toStatefulKnowledgeSession().don(this.internalMatch, core, trait, b, modes);
    }

    public ClassLoader getProjectClassLoader() {
        return ((InternalKnowledgeBase)this.getKieRuntime().getKieBase()).getRootClassLoader();
    }
}

