/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.kiesession.debug.NodeInfo;

public class DefaultNodeInfo
implements NodeInfo {
    private NetworkNode node;
    private Set<RuleImpl> rules;
    private long tupleMemorySize = -1L;
    private long factMemorySize = -1L;
    private long createdFactHandles = -1L;
    private long actionQueueSize = -1L;

    public DefaultNodeInfo(NetworkNode node) {
        this.node = node;
        this.rules = new HashSet<RuleImpl>();
    }

    public void assign(RuleImpl rule) {
        this.rules.add(rule);
    }

    @Override
    public Set<RuleImpl> getRules() {
        return this.rules;
    }

    @Override
    public int getId() {
        return this.node.getId();
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.node.getPartitionId();
    }

    @Override
    public long getTupleMemorySize() {
        return this.tupleMemorySize;
    }

    public void setTupleMemorySize(long leftMemorySize) {
        this.tupleMemorySize = leftMemorySize;
    }

    @Override
    public long getFactMemorySize() {
        return this.factMemorySize;
    }

    public void setFactMemorySize(long rightMemorySize) {
        this.factMemorySize = rightMemorySize;
    }

    @Override
    public long getCreatedFactHandles() {
        return this.createdFactHandles;
    }

    public void setCreatedFactHandles(long createdFactHandles) {
        this.createdFactHandles = createdFactHandles;
    }

    public long getActionQueueSize() {
        return this.actionQueueSize;
    }

    public void setActionQueueSize(long size) {
        this.actionQueueSize = size;
    }

    @Override
    public NetworkNode getNode() {
        return this.node;
    }

    @Override
    public Collection<? extends NetworkNode> getSinkList() {
        if (this.node instanceof Rete) {
            Rete rete = (Rete)this.node;
            return rete.getEntryPointNodes().values();
        }
        if (this.node instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)this.node;
            return epn.getObjectTypeNodes().values();
        }
        if (this.node instanceof ObjectSource) {
            ArrayList<ObjectSink> result = new ArrayList<ObjectSink>();
            for (ObjectSink sink : ((ObjectSource)this.node).getObjectSinkPropagator().getSinks()) {
                result.add(sink);
            }
            return result;
        }
        if (this.node instanceof LeftTupleSource) {
            ArrayList<LeftTupleSink> result = new ArrayList<LeftTupleSink>();
            LeftTupleSource source = (LeftTupleSource)this.node;
            for (LeftTupleSink sink : source.getSinkPropagator().getSinks()) {
                result.add(sink);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

