/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.facttemplates;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.facttemplates.Fact;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;

public class FactTemplateFieldExtractor
implements Externalizable,
ReadAccessor {
    private static final long serialVersionUID = 510L;
    private FactTemplate factTemplate;
    private String fieldName;
    private int fieldIndex;

    public FactTemplateFieldExtractor() {
    }

    public FactTemplateFieldExtractor(FactTemplate factTemplate, String fieldName) {
        this.factTemplate = factTemplate;
        this.fieldName = fieldName;
        this.fieldIndex = factTemplate.getFieldTemplateIndex(fieldName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.fieldName = in.readUTF();
        this.fieldIndex = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeUTF(this.fieldName);
        out.writeInt(this.fieldIndex);
    }

    @Override
    public ValueType getValueType() {
        return this.factTemplate.getFieldTemplate(this.fieldName).getValueType();
    }

    @Override
    public Object getValue(ValueResolver valueResolver, Object object) {
        return ((Fact)object).get(this.fieldName);
    }

    @Override
    public int getIndex() {
        return this.fieldIndex;
    }

    public Class getExtractToClass() {
        return this.factTemplate.getFieldTemplate(this.fieldName).getValueType().getClassType();
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName((Class)this.getExtractToClass());
    }

    @Override
    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        return (Boolean)((Fact)object).get(this.fieldName);
    }

    @Override
    public byte getByteValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).byteValue();
    }

    @Override
    public char getCharValue(ValueResolver valueResolver, Object object) {
        return ((Character)((Fact)object).get(this.fieldName)).charValue();
    }

    @Override
    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).doubleValue();
    }

    @Override
    public float getFloatValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).floatValue();
    }

    @Override
    public int getIntValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).intValue();
    }

    @Override
    public long getLongValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).longValue();
    }

    @Override
    public short getShortValue(ValueResolver valueResolver, Object object) {
        return ((Number)((Fact)object).get(this.fieldName)).shortValue();
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int getHashCode(ValueResolver valueResolver, Object object) {
        return this.getValue(valueResolver, object).hashCode();
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return ((Fact)object).get(this.fieldName) == null;
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.factTemplate == null ? 0 : this.factTemplate.hashCode());
        result = 31 * result + this.fieldIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactTemplateFieldExtractor other = (FactTemplateFieldExtractor)obj;
        if (this.factTemplate == null ? other.factTemplate != null : !this.factTemplate.equals(other.factTemplate)) {
            return false;
        }
        return this.fieldIndex == other.fieldIndex;
    }
}

