/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.List;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.kie.api.internal.assembler.ProcessedResource;
import org.kie.api.io.Resource;

public class JunctionTree
implements ProcessedResource {
    private Graph<BayesVariable> graph;
    private JunctionTreeClique root;
    private JunctionTreeClique[] jtNodes;
    private JunctionTreeSeparator[] jtSeps;
    private String namespace;
    private final Resource resource;
    private String name;

    public JunctionTree(Graph<BayesVariable> graph, JunctionTreeClique root, JunctionTreeClique[] jtNodes, JunctionTreeSeparator[] jtSeps) {
        this(null, null, null, graph, root, jtNodes, jtSeps, true);
    }

    public JunctionTree(Resource resource, String namespace, String name, Graph<BayesVariable> graph, JunctionTreeClique root, JunctionTreeClique[] jtNodes, JunctionTreeSeparator[] jtSeps) {
        this(resource, namespace, name, graph, root, jtNodes, jtSeps, true);
    }

    public JunctionTree(Resource resource, String namespace, String name, Graph<BayesVariable> graph, JunctionTreeClique root, JunctionTreeClique[] jtNodes, JunctionTreeSeparator[] jtSeps, boolean init) {
        this.resource = resource;
        this.namespace = namespace;
        this.name = name;
        this.graph = graph;
        this.root = root;
        this.jtNodes = jtNodes;
        this.jtSeps = jtSeps;
        if (init) {
            this.initialize();
        }
    }

    public Graph<BayesVariable> getGraph() {
        return this.graph;
    }

    public JunctionTreeClique getRoot() {
        return this.root;
    }

    private void initialize() {
        this.recurseJTNodesAndInitialisePotentials(this.graph, this.root);
    }

    public void recurseJTNodesAndInitialisePotentials(Graph graph, JunctionTreeClique jtNode) {
        BayesVariable[] vars = jtNode.getValues().toArray(new BayesVariable[jtNode.getValues().size()]);
        List<BayesVariable> family = jtNode.getFamily();
        int numberOfStates = PotentialMultiplier.createNumberOfStates(vars);
        int[] multipliers = PotentialMultiplier.createIndexMultipliers(vars, numberOfStates);
        for (BayesVariable var : family) {
            this.multipleVarNodePotential(graph.getNode(var.getId()), jtNode.getPotentials(), vars, multipliers);
        }
        List<JunctionTreeSeparator> seps = jtNode.getChildren();
        for (JunctionTreeSeparator sep : seps) {
            this.recurseJTNodesAndInitialisePotentials(graph, sep.getChild());
        }
    }

    public void multipleVarNodePotential(GraphNode<BayesVariable> varNode, double[] potentials, BayesVariable[] vars, int[] multipliers) {
        BayesVariable[] parents = new BayesVariable[varNode.getInEdges().size()];
        for (int i = 0; i < parents.length; ++i) {
            parents[i] = (BayesVariable)varNode.getInEdges().get(i).getOutGraphNode().getContent();
        }
        int[] parentVarPos = PotentialMultiplier.createSubsetVarPos(vars, parents);
        int parentsNumberOfStates = PotentialMultiplier.createNumberOfStates(parents);
        int[] parentIndexMultipliers = PotentialMultiplier.createIndexMultipliers(parents, parentsNumberOfStates);
        BayesVariable var = varNode.getContent();
        int varPos = -1;
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] != var) continue;
            varPos = i;
            break;
        }
        if (varPos == -1 || varPos == vars.length) {
            throw new IllegalStateException("Unable to find Variable in set");
        }
        PotentialMultiplier m = new PotentialMultiplier(varNode.getContent().getProbabilityTable(), varPos, parentVarPos, parentIndexMultipliers, vars, multipliers, potentials);
        m.multiple();
    }

    public JunctionTreeClique[] getJunctionTreeNodes() {
        return this.jtNodes;
    }

    public JunctionTreeSeparator[] getJunctionTreeSeparators() {
        return this.jtSeps;
    }

    public void setJunctionTreeNodes(JunctionTreeClique[] jtNodes) {
        this.jtNodes = jtNodes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getName() {
        return this.name;
    }
}

