/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.marshalling;

import org.kie.api.KieBase;
import org.kie.api.internal.utils.KieService;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;

public class MarshallerFactory {
    private static volatile KieMarshallers provider;

    public static ObjectMarshallingStrategyAcceptor newClassFilterAcceptor(String[] patterns) {
        return MarshallerFactory.getMarshallerProvider().newClassFilterAcceptor(patterns);
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy(acceptor);
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy(acceptor);
    }

    public static Marshaller newMarshaller(KieBase kbase) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase);
    }

    public static Marshaller newMarshaller(KieBase kbase, ObjectMarshallingStrategy[] strategies) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase, strategies);
    }

    private static synchronized void setMarshallerProvider(KieMarshallers provider) {
        MarshallerFactory.provider = provider;
    }

    private static synchronized KieMarshallers getMarshallerProvider() {
        if (provider == null) {
            MarshallerFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        MarshallerFactory.setMarshallerProvider((KieMarshallers)KieService.load(KieMarshallers.class));
    }
}

