/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.EvaluatorCache;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class MatchesEvaluatorsDefinition
implements EvaluatorDefinition {
    protected static final String matchesOp = Operator.BuiltInOperator.MATCHES.getSymbol();
    public static final Operator MATCHES = Operator.determineOperator((String)matchesOp, (boolean)false);
    public static final Operator NOT_MATCHES = Operator.determineOperator((String)matchesOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{matchesOp};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.STRING_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator((String)operatorId, (boolean)isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static class StringNotMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMatchesEvaluator();

        public StringNotMatchesEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MATCHES);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(valueResolver, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return !value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return !value.matches((String)context.declaration.getExtractor().getValue(valueResolver, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            String value = (String)context.extractor.getValue(valueResolver, right.getObject());
            if (value == null) {
                return false;
            }
            return !value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            Object value1 = extractor1.getValue(valueResolver, handle1.getObject());
            Object value2 = extractor2.getValue(valueResolver, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return !((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String not matches";
        }
    }

    public static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        public StringMatchesEvaluator() {
            super(ValueType.STRING_TYPE, MATCHES);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(valueResolver, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return value.matches((String)context.declaration.getExtractor().getValue(valueResolver, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            String value = (String)context.extractor.getValue(valueResolver, right.getObject());
            if (value == null) {
                return false;
            }
            return value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            Object value1 = extractor1.getValue(valueResolver, handle1.getObject());
            Object value2 = extractor2.getValue(valueResolver, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return ((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String matches";
        }
    }
}

