/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.util.TimeIntervalParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public abstract class PointInTimeEvaluator
extends BaseEvaluator {
    protected long initRange;
    protected long finalRange;
    protected String paramText;
    protected boolean unwrapLeft;
    protected boolean unwrapRight;

    public PointInTimeEvaluator() {
    }

    public PointInTimeEvaluator(ValueType type, Operator operator, long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
        super(type, operator);
        this.paramText = paramText;
        this.unwrapLeft = unwrapLeft;
        this.unwrapRight = unwrapRight;
        this.setParameters(parameters);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.initRange = in.readLong();
        this.finalRange = in.readLong();
        this.paramText = (String)in.readObject();
        this.unwrapLeft = in.readBoolean();
        this.unwrapRight = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.initRange);
        out.writeLong(this.finalRange);
        out.writeObject(this.paramText);
        out.writeBoolean(this.unwrapLeft);
        out.writeBoolean(this.unwrapRight);
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    protected abstract boolean evaluate(long var1, long var3);

    protected abstract long getLeftTimestamp(FactHandle var1);

    protected abstract long getRightTimestamp(FactHandle var1);

    private long getTimestamp(FieldValue value) {
        Object obj = value.getValue();
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return TimeIntervalParser.getTimestampFromDate((Object)obj);
    }

    public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle object1, FieldValue object2) {
        long rightTS = extractor.isSelfReference() ? this.getRightTimestamp(object1) : extractor.getLongValue(valueResolver, object1.getObject());
        long leftTS = this.getTimestamp(object2);
        return this.evaluate(rightTS, leftTS);
    }

    @Override
    public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
        if (context.leftNull || context.extractor.isNullValue(valueResolver, right.getObject())) {
            return false;
        }
        long leftTS = ((VariableRestriction.TimestampedContextEntry)context).timestamp;
        long rightTS = context.getFieldExtractor().isSelfReference() ? this.getRightTimestamp(right) : context.getFieldExtractor().getLongValue(valueResolver, right.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    @Override
    public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
        if (context.rightNull || context.declaration.getExtractor().isNullValue(valueResolver, left.getObject())) {
            return false;
        }
        long rightTS = ((VariableRestriction.TimestampedContextEntry)context).timestamp;
        long leftTS = context.declaration.getExtractor().isSelfReference() ? this.getLeftTimestamp(left) : context.declaration.getExtractor().getLongValue(valueResolver, left.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
        if (extractor1.isNullValue(valueResolver, handle1.getObject()) || extractor2.isNullValue(valueResolver, handle2.getObject())) {
            return false;
        }
        long rightTS = extractor1.isSelfReference() ? this.getRightTimestamp(handle1) : extractor1.getLongValue(valueResolver, handle1.getObject());
        long leftTS = extractor2.isSelfReference() ? this.getLeftTimestamp(handle2) : extractor2.getLongValue(valueResolver, handle2.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    private void setParameters(long[] parameters) {
        if (parameters == null || parameters.length == 0) {
            this.initRange = 1L;
            this.finalRange = Long.MAX_VALUE;
        } else if (parameters.length == 1) {
            this.initRange = parameters[0];
            this.finalRange = Long.MAX_VALUE;
        } else if (parameters.length == 2) {
            if (parameters[0] <= parameters[1]) {
                this.initRange = parameters[0];
                this.finalRange = parameters[1];
            } else {
                this.initRange = parameters[1];
                this.finalRange = parameters[0];
            }
        } else {
            throw new RuntimeException("[PointInTimeEvaluator Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
        }
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
        result = 31 * result + (int)(this.initRange ^ this.initRange >>> 32);
        result = 31 * result + (this.paramText == null ? 0 : this.paramText.hashCode());
        result = 31 * result + (this.unwrapLeft ? 1231 : 1237);
        result = 31 * result + (this.unwrapRight ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointInTimeEvaluator other = (PointInTimeEvaluator)obj;
        if (this.finalRange != other.finalRange) {
            return false;
        }
        if (this.initRange != other.initRange) {
            return false;
        }
        if (this.paramText == null ? other.paramText != null : !this.paramText.equals(other.paramText)) {
            return false;
        }
        return this.unwrapLeft == other.unwrapLeft && this.unwrapRight == other.unwrapRight;
    }

    @Override
    public String toString() {
        return this.getOperator().toString() + "[" + this.paramText + "]";
    }
}

