/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.core.BaseConfiguration;
import org.drools.core.ClockType;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.util.StringUtils;
import org.kie.api.KieBase;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.OptionKey;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KeepReferenceOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.internal.conf.CompositeConfiguration;

public class SessionConfiguration
extends BaseConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption>
implements KieSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    public static final ConfigurationKey<SessionConfiguration> KEY = new ConfigurationKey("Base");
    private boolean keepReference;
    private ClockType clockType;
    private TimerJobFactoryType timerJobFactoryType;
    private PersistedSessionOption persistedSessionOption;
    private ExecutableRunner runner;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
        out.writeObject(this.timerJobFactoryType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
        try {
            this.timerJobFactoryType = (TimerJobFactoryType)in.readObject();
        }
        catch (InvalidObjectException e) {
            if (e.getMessage().contains("DEFUALT")) {
                this.timerJobFactoryType = TimerJobFactoryType.DEFAULT;
            }
            throw e;
        }
    }

    public SessionConfiguration(CompositeConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.setKeepReference(Boolean.parseBoolean(this.getPropertyValue("drools.keepReference", "true")));
        this.setClockType(ClockType.resolveClockType(this.getPropertyValue("drools.clockType", ClockType.REALTIME_CLOCK.getId())));
        this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(this.getPropertyValue("drools.timerJobFactory", TimerJobFactoryType.THREAD_SAFE_TRACKABLE.getId())));
    }

    public final <T extends KieSessionOption> void setOption(T option) {
        switch (option.propertyName()) {
            case "drools.clockType": {
                this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
                break;
            }
            case "drools.timerJobFactory": {
                this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(((TimerJobFactoryOption)option).getTimerJobType()));
                break;
            }
            case "drools.keepReference": {
                this.setKeepReference(((KeepReferenceOption)option).isKeepReference());
                break;
            }
            case "drools.persistedsession": {
                this.setPersistedSessionOption((PersistedSessionOption)option);
                break;
            }
            default: {
                this.compConfig.setOption(option);
            }
        }
    }

    public final <T extends SingleValueKieSessionOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.clockType": {
                return (T)ClockTypeOption.get((String)this.getClockType().toExternalForm());
            }
            case "drools.timerJobFactory": {
                return (T)TimerJobFactoryOption.get((String)this.getTimerJobFactoryType().toExternalForm());
            }
            case "drools.keepReference": {
                return (T)(this.isKeepReference() ? KeepReferenceOption.YES : KeepReferenceOption.NO);
            }
            case "drools.persistedsession": {
                return (T)this.getPersistedSessionOption();
            }
        }
        return (T)((SingleValueKieSessionOption)this.compConfig.getOption(option));
    }

    public final <T extends MultiValueKieSessionOption> T getOption(OptionKey<T> option, String subKey) {
        return (T)((MultiValueKieSessionOption)this.compConfig.getOption(option, subKey));
    }

    public <C extends MultiValueKieSessionOption> Set<String> getOptionSubKeys(OptionKey<C> optionKey) {
        return this.compConfig.getOptionSubKeys(optionKey);
    }

    public final boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "drools.clockType": {
                this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty((CharSequence)value) ? "realtime" : value));
                break;
            }
            case "drools.timerJobFactory": {
                this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(StringUtils.isEmpty((CharSequence)value) ? "default" : value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public final String getInternalProperty(String name) {
        switch (name) {
            case "drools.clockType": {
                return this.getClockType().toExternalForm();
            }
            case "drools.timerJobFactory": {
                return this.getTimerJobFactoryType().toExternalForm();
            }
        }
        return null;
    }

    public SessionConfiguration addDefaultProperties(Properties properties) {
        Properties defaultProperties = new Properties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (this.getProperties().getProperty((String)prop.getKey(), null) != null) continue;
            defaultProperties.put(prop.getKey(), prop.getValue());
        }
        this.getProperties().addProperties(defaultProperties);
        return this;
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public boolean hasPersistedSessionOption() {
        return this.persistedSessionOption != null;
    }

    public PersistedSessionOption getPersistedSessionOption() {
        return this.persistedSessionOption;
    }

    private void setPersistedSessionOption(PersistedSessionOption persistedSessionOption) {
        this.persistedSessionOption = persistedSessionOption;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType;
    }

    public void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        this.checkCanChange();
        this.timerJobFactoryType = timerJobFactoryType;
    }

    public final TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.getTimerJobFactoryType().createInstance();
    }

    public ExecutableRunner getRunner(KieBase kbase, Environment environment) {
        if (this.runner == null) {
            this.initCommandService(kbase, environment);
        }
        return this.runner;
    }

    private void initCommandService(KieBase kbase, Environment environment) {
        String className = this.getPropertyValue("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.runner = (ExecutableRunner)clazz.getConstructor(KieBase.class, KieSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    public TimerService createTimerService() {
        TimerService service = this.getClockType().createInstance();
        service.setTimerJobFactoryManager(this.getTimerJobFactoryManager());
        return service;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConfiguration that = (SessionConfiguration)o;
        return this.getClockType() == that.getClockType() && this.getTimerJobFactoryType() == that.getTimerJobFactoryType();
    }

    public final int hashCode() {
        int result = this.getClockType().hashCode();
        result = 31 * result + this.getTimerJobFactoryType().hashCode();
        return result;
    }
}

