/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time;

import java.util.List;
import java.util.stream.IntStream;
import org.drools.base.rule.Pattern;
import org.drools.base.time.Interval;

public class TemporalDependencyMatrix {
    private Interval[][] matrix;
    private List<Pattern> events;

    public TemporalDependencyMatrix(Interval[][] matrix, List<Pattern> events) {
        this.matrix = matrix;
        this.events = events;
    }

    public Interval[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Interval[][] matrix) {
        this.matrix = matrix;
    }

    public List<Pattern> getEvents() {
        return this.events;
    }

    public void setEvents(List<Pattern> events) {
        this.events = events;
    }

    public long getExpirationOffset(Pattern pattern) {
        int index = this.events.indexOf(pattern);
        Interval[] intervals = this.matrix[index];
        long expiration = IntStream.range(0, intervals.length).filter(i -> i != index).mapToLong(i -> intervals[i].getUpperBound()).max().orElse(-1L);
        return expiration >= 0L && expiration != Long.MAX_VALUE ? expiration + 1L : -1L;
    }
}

