/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import org.junit.Assert;
import org.junit.Test;

public class MultipleRepositoryTest {
    @Test
    public void testMultipleInstances() throws Exception {
        RuleRuntime ruleRuntime1 = this.getServiceProvider("engine1", "multiple-engine1.drl").getRuleRuntime();
        RuleRuntime ruleRuntime2 = this.getServiceProvider("engine2", "multiple-engine2.drl").getRuleRuntime();
        System.out.println(ruleRuntime1.getRegistrations().size());
        Assert.assertTrue((ruleRuntime1.getRegistrations().size() == 1 ? 1 : 0) != 0);
        System.out.println(ruleRuntime2.getRegistrations().size());
        Assert.assertTrue((ruleRuntime2.getRegistrations().size() == 1 ? 1 : 0) != 0);
        this.execute(ruleRuntime1, "Engine1", new Object[]{"value1"});
        this.execute(ruleRuntime2, "Engine2", new Object[]{"value2"});
    }

    public RuleServiceProvider getServiceProvider(String url, String ruleset) throws Exception {
        Class<?> clazz = this.getClass().getClassLoader().loadClass("org.drools.jsr94.rules.RuleServiceProviderImpl");
        RuleServiceProviderManager.registerRuleServiceProvider((String)url, clazz);
        RuleServiceProvider serviceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)url);
        RuleAdministrator ruleAdministrator = serviceProvider.getRuleAdministrator();
        InputStream inStream = this.getClass().getResourceAsStream(ruleset);
        RuleExecutionSet res1 = ruleAdministrator.getLocalRuleExecutionSetProvider(null).createRuleExecutionSet(inStream, null);
        inStream.close();
        String uri = res1.getName();
        System.out.println(uri);
        ruleAdministrator.registerRuleExecutionSet(uri, res1, null);
        return serviceProvider;
    }

    public void execute(RuleRuntime rt, String ruleset, Object[] input) throws Exception {
        StatelessRuleSession srs = (StatelessRuleSession)rt.createRuleSession(ruleset, null, 1);
        List output = srs.executeRules(Arrays.asList(input));
        System.out.println(output);
    }
}

