/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import org.drools.core.RuleBaseConfiguration;
import org.drools.jsr94.rules.RuleEngineTestBase;
import org.drools.jsr94.rules.RuleServiceProviderImpl;
import org.drools.jsr94.rules.decisiontables.SpreadsheetIntegrationExampleTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleRuntimeTest
extends RuleEngineTestBase {
    private LocalRuleExecutionSetProvider ruleSetProvider;
    private RuleAdministrator ruleAdministrator;
    private String RULES_RESOURCE;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.RULES_RESOURCE = this.bindUri;
        this.ruleAdministrator = this.ruleServiceProvider.getRuleAdministrator();
        this.ruleSetProvider = this.ruleAdministrator.getLocalRuleExecutionSetProvider(null);
    }

    @Test
    public void testCreateRuleStatelessRuleSession() throws Exception {
        RuleRuntime ruleRuntime = this.ruleServiceProvider.getRuleRuntime();
        Assert.assertNotNull((String)"cannot obtain RuleRuntime", (Object)ruleRuntime);
        try {
            ruleRuntime.createRuleSession("someUri", null, 1);
            Assert.fail((String)"RuleExecutionSetNotFoundException expected");
        }
        catch (RuleExecutionSetNotFoundException ex) {
            // empty catch block
        }
        InputStreamReader ruleReader = new InputStreamReader(RuleRuntimeTest.class.getResourceAsStream(this.RULES_RESOURCE));
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, null);
        this.ruleAdministrator.registerRuleExecutionSet(this.RULES_RESOURCE, ruleSet, null);
        StatelessRuleSession statelessRuleSession = (StatelessRuleSession)ruleRuntime.createRuleSession(this.RULES_RESOURCE, null, 1);
        Assert.assertNotNull((String)"cannot obtain StatelessRuleSession", (Object)statelessRuleSession);
        this.ruleAdministrator.deregisterRuleExecutionSet(this.RULES_RESOURCE, null);
    }

    @Test
    public void testCreateRuleStatefulRuleSession() throws Exception {
        RuleRuntime ruleRuntime = this.ruleServiceProvider.getRuleRuntime();
        Assert.assertNotNull((String)"cannot obtain RuleRuntime", (Object)ruleRuntime);
        try {
            ruleRuntime.createRuleSession("someUri", null, 0);
            Assert.fail((String)"RuleExecutionSetNotFoundException expected");
        }
        catch (RuleExecutionSetNotFoundException ex) {
            // empty catch block
        }
        InputStreamReader ruleReader = new InputStreamReader(RuleRuntimeTest.class.getResourceAsStream(this.RULES_RESOURCE));
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, null);
        this.ruleAdministrator.registerRuleExecutionSet(this.RULES_RESOURCE, ruleSet, null);
        StatefulRuleSession statefulRuleSession = (StatefulRuleSession)ruleRuntime.createRuleSession(this.RULES_RESOURCE, null, 0);
        Assert.assertNotNull((String)"cannot obtain StatefulRuleSession", (Object)statefulRuleSession);
        this.ruleAdministrator.deregisterRuleExecutionSet(this.RULES_RESOURCE, null);
    }

    @Test
    public void testGetRegistrations() throws Exception {
        RuleRuntime ruleRuntime = this.ruleServiceProvider.getRuleRuntime();
        Assert.assertNotNull((String)"cannot obtain RuleRuntime", (Object)ruleRuntime);
        InputStreamReader ruleReader = new InputStreamReader(RuleRuntimeTest.class.getResourceAsStream(this.RULES_RESOURCE));
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, null);
        this.ruleAdministrator.registerRuleExecutionSet(this.RULES_RESOURCE, ruleSet, null);
        List list = ruleRuntime.getRegistrations();
        Assert.assertTrue((String)"no registrations found", (list.size() > 0 ? 1 : 0) != 0);
        this.ruleAdministrator.deregisterRuleExecutionSet(this.RULES_RESOURCE, null);
    }

    @Test
    public void testRuleBaseConfigurationConstant() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.rules.admin.RuleExecutionSet.source", "javax.rules.admin.RuleExecutionSet.source.decisiontable");
        properties.put("javax.rules.admin.RuleExecutionSet.ruleBaseConfiguration", (String)new RuleBaseConfiguration());
        RuleServiceProviderManager.registerRuleServiceProvider((String)"http://drools.org/", RuleServiceProviderImpl.class);
        RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)"http://drools.org/");
        RuleAdministrator ruleAdministrator = ruleServiceProvider.getRuleAdministrator();
        LocalRuleExecutionSetProvider ruleSetProvider = ruleAdministrator.getLocalRuleExecutionSetProvider(null);
        try {
            RuleExecutionSet ruleExecutionSet = ruleSetProvider.createRuleExecutionSet(SpreadsheetIntegrationExampleTest.class.getResourceAsStream("IntegrationExampleTest.xls"), properties);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

