/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.GeneratedMvelParser;
import org.drools.mvel.parser.MvelParser;
import org.drools.mvel.parser.ParseStart;
import org.drools.mvel.parser.Provider;
import org.drools.mvel.parser.StringProvider;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.DrlxExpression;
import org.drools.mvel.parser.ast.expr.HalfBinaryExpr;
import org.drools.mvel.parser.ast.expr.HalfPointFreeExpr;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.ast.expr.OOPathChunk;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.ast.expr.PointFreeExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.junit.Test;

public class DroolsMvelParserTest {
    private static final Collection<String> operators = new HashSet<String>();
    final ParseStart<DrlxExpression> parser = DrlxParser.buildDrlxParserWithArguments(operators);

    @Test
    public void testParseSimpleExpr() {
        String expr = "name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mark\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testBinaryWithNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\n                   addresses == 3  )").getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)or)).isEqualTo("(addresses == 2 || addresses == 3)");
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\n addresses == 3  )").getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)and)).isEqualTo("(addresses == 2 && addresses == 3)");
    }

    @Test
    public void testBinaryWithWindowsNewLine() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 ||\r\n                   addresses == 3  )").getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)or)).isEqualTo("(addresses == 2 || addresses == 3)");
        Expression and = DrlxParser.parseExpression(this.parser, (String)"(addresses == 2 &&\r\n addresses == 3  )").getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)and)).isEqualTo("(addresses == 2 && addresses == 3)");
    }

    @Test
    public void testBinaryWithNewLineBeginning() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)("(" + this.newLine() + "addresses == 2 || addresses == 3  )")).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)or)).isEqualTo("(addresses == 2 || addresses == 3)");
        Expression and = DrlxParser.parseExpression(this.parser, (String)("(" + this.newLine() + "addresses == 2 && addresses == 3  )")).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)and)).isEqualTo("(addresses == 2 && addresses == 3)");
    }

    @Test
    public void testBinaryWithNewLineEnd() {
        Expression or = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 || addresses == 3 " + this.newLine() + ")")).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)or)).isEqualTo("(addresses == 2 || addresses == 3)");
        Expression and = DrlxParser.parseExpression(this.parser, (String)("(addresses == 2 && addresses == 3 " + this.newLine() + ")")).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)and)).isEqualTo("(addresses == 2 && addresses == 3)");
    }

    @Test
    public void testBinaryWithNewLineBeforeOperator() {
        String andExpr = "(addresses == 2" + this.newLine() + "&& addresses == 3  )";
        MvelParser mvelParser1 = new MvelParser(new ParserConfiguration(), true);
        Expression and2 = (Expression)mvelParser1.parse(GeneratedMvelParser::Expression, (Provider)new StringProvider(andExpr)).getResult().get();
        Assertions.assertThat((String)PrintUtil.printNode((Node)and2)).isEqualTo("(addresses == 2 && addresses == 3)");
        String orExpr = "(addresses == 2" + this.newLine() + "|| addresses == 3  )";
        MvelParser mvelParser2 = new MvelParser(new ParserConfiguration(), false);
        Expression or2 = (Expression)mvelParser2.parse(GeneratedMvelParser::Expression, (Provider)new StringProvider(orExpr)).getResult().get();
        Assertions.assertThat((String)PrintUtil.printNode((Node)or2)).isEqualTo("(addresses == 2 || addresses == 3)");
    }

    @Test
    public void testParseSafeCastExpr() {
        String expr = "this instanceof Person && ((Person) this).name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testParseInlineCastExpr() {
        String expr = "this#Person.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testParseInlineCastExpr2() {
        String expr = "address#com.pkg.InternationalAddress.state.length == 5";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testParseInlineCastExpr3() {
        String expr = "address#org.drools.mvel.compiler.LongAddress.country.substring(1)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testParseInlineCastExpr4() {
        String expr = "address#com.pkg.InternationalAddress.getState().length == 5";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testParseNullSafeFieldAccessExpr() {
        String expr = "person!.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testDotFreeExpr() {
        String expr = "this after $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testDotFreeEnclosed() {
        String expr = "(this after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testDotFreeEnclosedWithNameExpr() {
        String expr = "(something after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testLiteral() {
        String bigDecimalLiteral = "bigInteger < (50B)";
        Expression bigDecimalExpr = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteral).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)bigDecimalExpr)).isEqualTo(bigDecimalLiteral);
        String bigIntegerLiteral = "bigInteger == (50I)";
        Expression bigIntegerExpr = DrlxParser.parseExpression(this.parser, (String)bigIntegerLiteral).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)bigIntegerExpr)).isEqualTo(bigIntegerLiteral);
    }

    @Test
    public void testBigDecimalLiteral() {
        String bigDecimalLiteralWithDecimals = "12.111B";
        Expression bigDecimalExprWithDecimals = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteralWithDecimals).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)bigDecimalExprWithDecimals)).isEqualTo(bigDecimalLiteralWithDecimals);
    }

    @Test
    public void testDotFreeExprWithOr() {
        String expr = "this after $a || this after $b";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof BinaryExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testDotFreeExprWithArgs() {
        String expr = "this after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((boolean)((PointFreeExpr)expression).isNegated()).isFalse();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("this after[5ms,8ms] $a");
    }

    @Test
    public void testDotFreeExprWithArgsInfinite() {
        String expr = "this after[5s,*] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((boolean)((PointFreeExpr)expression).isNegated()).isFalse();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("this after[5s,*] $a");
    }

    @Test
    public void testDotFreeExprWithThreeArgsInfinite() {
        String expr = "this after[*,*,*,2s] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((boolean)((PointFreeExpr)expression).isNegated()).isFalse();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("this after[*,*,*,2s] $a");
    }

    @Test
    public void testDotFreeExprWithArgsNegated() {
        String expr = "this not after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        Assertions.assertThat((boolean)((PointFreeExpr)expression).isNegated()).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("this not after[5ms,8ms] $a");
    }

    @Test
    public void testDotFreeExprWithTemporalArgs() {
        String expr = "this after[5ms,8d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testDotFreeExprWithFourTemporalArgs() {
        String expr = "this includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testHalfDotFreeExprWithFourTemporalArgs() {
        String expr = "includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test(expected=ParseProblemException.class)
    public void testInvalidTemporalArgs() {
        String expr = "this after[5ms,8f] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
    }

    @Test
    public void testOOPathExpr() {
        String expr = "/wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assertions.assertThat((boolean)(expression instanceof OOPathExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testOOPathExprWithDot() {
        String expr = "/wife.children/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assertions.assertThat((boolean)(expression instanceof OOPathExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testOOPathExprWithMultipleCondition() {
        String expr = "$address : /address[street == \"Elm\",city == \"Big City\"]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assertions.assertThat((boolean)(expression instanceof OOPathExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testOOPathExprWithDeclaration() {
        String expr = "$toy : /wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)drlx.getBind().asString()).isEqualTo("$toy");
        Expression expression = drlx.getExpr();
        Assertions.assertThat((boolean)(expression instanceof OOPathExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testOOPathExprWithBackReference() {
        String expr = "$toy : /wife/children/toys[name.length == ../../name.length]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)drlx.getBind().asString()).isEqualTo("$toy");
        Expression expression = drlx.getExpr();
        Assertions.assertThat((boolean)(expression instanceof OOPathExpr)).isTrue();
        OOPathChunk secondChunk = (OOPathChunk)((OOPathExpr)expression).getChunks().get(2);
        BinaryExpr secondChunkFirstCondition = (BinaryExpr)((DrlxExpression)secondChunk.getConditions().get(0)).getExpr();
        DrlNameExpr rightName = (DrlNameExpr)((FieldAccessExpr)secondChunkFirstCondition.getRight()).getScope();
        Assertions.assertThat((int)rightName.getBackReferencesCount()).isEqualTo(2);
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testMapInitializationEmpty() {
        String expr = "countItems([])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testMapInitializationLiteralAsArgument() {
        String expr = "countItems([123 : 456, 789 : 1011])";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
    }

    @Test
    public void testParseTemporalLiteral() {
        String expr = "5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
        Assertions.assertThat((int)drlx.getChunks().size()).isEqualTo(1);
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assertions.assertThat((int)chunk0.getValue()).isEqualTo(5);
        Assertions.assertThat((Comparable)((Object)chunk0.getTimeUnit())).isEqualTo((Object)TimeUnit.SECONDS);
    }

    @Test
    public void testParseTemporalLiteralOf2Chunks() {
        String expr = "1m5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)drlx)).isEqualTo(expr);
        Assertions.assertThat((int)drlx.getChunks().size()).isEqualTo(2);
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assertions.assertThat((int)chunk0.getValue()).isEqualTo(1);
        Assertions.assertThat((Comparable)((Object)chunk0.getTimeUnit())).isEqualTo((Object)TimeUnit.MINUTES);
        TemporalLiteralChunkExpr chunk1 = (TemporalLiteralChunkExpr)drlx.getChunks().get(1);
        Assertions.assertThat((int)chunk1.getValue()).isEqualTo(5);
        Assertions.assertThat((Comparable)((Object)chunk1.getTimeUnit())).isEqualTo((Object)TimeUnit.SECONDS);
    }

    @Test
    public void testInExpression() {
        String expr = "this in ()";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof PointFreeExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testUnsupportedImplicitParameter() {
        String expr = "== \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((boolean)(expression instanceof HalfBinaryExpr)).isTrue();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testAndWithImplicitNegativeParameter() {
        String expr = "value > -2 && < -1";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("-2");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("-1");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesis() {
        String expr = "value (> 1 && < 2)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisOnThis() {
        String expr = "this (> 1 && < 2)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("this");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplex() {
        String expr = "value ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((Comparable)comboExprLeft.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assertions.assertThat((Comparable)comboExprRight.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assertions.assertThat((String)this.toString((Node)third.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assertions.assertThat((String)this.toString((Node)forth.getRight())).isEqualTo("4");
        Assertions.assertThat((Comparable)forth.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplexOnField() {
        String expr = "value.length ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((Comparable)comboExprLeft.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assertions.assertThat((boolean)(first.getLeft() instanceof FieldAccessExpr)).isTrue();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value.length");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assertions.assertThat((Comparable)comboExprRight.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assertions.assertThat((String)this.toString((Node)third.getLeft())).isEqualTo("value.length");
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assertions.assertThat((String)this.toString((Node)forth.getRight())).isEqualTo("4");
        Assertions.assertThat((Comparable)forth.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisComplexOnNullSafeField() {
        String expr = "value!.length ((> 1 && < 2) || (> 3 && < 4))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((Comparable)comboExprLeft.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assertions.assertThat((boolean)(first.getLeft() instanceof NullSafeFieldAccessExpr)).isTrue();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value!.length");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assertions.assertThat((Comparable)comboExprRight.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assertions.assertThat((String)this.toString((Node)third.getLeft())).isEqualTo("value!.length");
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assertions.assertThat((String)this.toString((Node)forth.getRight())).isEqualTo("4");
        Assertions.assertThat((Comparable)forth.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisMixedLeft() {
        String expr = "value ((> 1 && < 2) || > 3)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr comboExprLeft = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((Comparable)comboExprLeft.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)comboExprLeft.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr second = (HalfBinaryExpr)comboExprLeft.getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
        BinaryExpr third = (BinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)third.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
    }

    @Test
    public void testAndWithImplicitParameterAndParenthesisMixedRight() {
        String expr = "value (< 1 || (> 2 && < 3))";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("1");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.LESS);
        BinaryExpr comboExprRight = (BinaryExpr)comboExpr.getRight();
        Assertions.assertThat((Comparable)comboExprRight.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr third = (BinaryExpr)comboExprRight.getLeft();
        Assertions.assertThat((String)this.toString((Node)third.getLeft())).isEqualTo("value");
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        HalfBinaryExpr forth = (HalfBinaryExpr)comboExprRight.getRight();
        Assertions.assertThat((String)this.toString((Node)forth.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)forth.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.LESS);
    }

    @Test
    public void testOrWithImplicitParameter() {
        String expr = "name == \"Mark\" || == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("\"Mark\"");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("\"Luca\"");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testAndWithImplicitParameter() {
        String expr = "name == \"Mark\" && == \"Mario\" && == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("\"Mark\"");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("\"Luca\"");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testAndWithImplicitParameter2() {
        String expr = "name == \"Mark\" && == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        Assertions.assertThat((Comparable)((BinaryExpr)comboExpr.getLeft()).getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("\"Mark\"");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("\"Luca\"");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testAndWithImplicitParameter3() {
        String expr = "age == 2 && == 3 || == 4";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assertions.assertThat((Comparable)comboExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.OR);
        Assertions.assertThat((Comparable)((BinaryExpr)comboExpr.getLeft()).getOperator()).isEqualTo((Object)BinaryExpr.Operator.AND);
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assertions.assertThat((String)this.toString((Node)first.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)first.getRight())).isEqualTo("2");
        Assertions.assertThat((Comparable)first.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assertions.assertThat((String)this.toString((Node)second.getRight())).isEqualTo("3");
        Assertions.assertThat((Comparable)second.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assertions.assertThat((String)this.toString((Node)third.getRight())).isEqualTo("4");
        Assertions.assertThat((Comparable)third.getOperator()).isEqualTo((Object)HalfBinaryExpr.Operator.EQUALS);
    }

    @Test
    public void dotFreeWithRegexp() {
        String expr = "name matches \"[a-z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("name matches \"[a-z]*\"");
        PointFreeExpr e = (PointFreeExpr)expression;
        Assertions.assertThat((String)e.getOperator().asString()).isEqualTo("matches");
        Assertions.assertThat((String)this.toString((Node)e.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString(e.getRight().get(0))).isEqualTo("\"[a-z]*\"");
    }

    @Test
    public void implicitOperatorWithRegexps() {
        String expr = "name matches \"[a-z]*\" || matches \"pippo\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("name matches \"[a-z]*\" || matches \"pippo\"");
    }

    @Test
    public void halfPointFreeExpr() {
        String expr = "matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("matches \"[A-Z]*\"");
    }

    @Test
    public void halfPointFreeExprNegated() {
        String expr = "not matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(HalfPointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("not matches \"[A-Z]*\"");
    }

    @Test
    public void regressionTestHalfPointFree() {
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getAddress().getAddressName().length() == 5").getExpr()).isInstanceOf(BinaryExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isFortyYearsOld(this, true)").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getName().startsWith(\"M\")").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isPositive($i.intValue())").getExpr()).isInstanceOf(MethodCallExpr.class);
        Assertions.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"someEntity.someString in (\"1.500\")").getExpr()).isInstanceOf(PointFreeExpr.class);
    }

    @Test
    public void mvelSquareBracketsOperators() {
        this.testMvelSquareOperator("this str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", false);
        this.testMvelSquareOperator("this not str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", true);
        this.testMvelSquareOperator("this str[endsWith] \"K\"", "str[endsWith]", "this", "\"K\"", false);
        this.testMvelSquareOperator("this str[length] 17", "str[length]", "this", "17", false);
    }

    @Test
    public void halfPointFreeMVEL() {
        String expr = "this str[startsWith] \"M\" || str[startsWith] \"E\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("this str[startsWith] \"M\" || str[startsWith] \"E\"");
        Expression expression2 = DrlxParser.parseExpression(this.parser, (String)"str[startsWith] \"E\"").getExpr();
        Assertions.assertThat((Object)expression2).isInstanceOf(HalfPointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression2)).isEqualTo("str[startsWith] \"E\"");
    }

    @Test
    public void testLambda() {
        String expr = "x -> y";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testLambdaParameter() {
        String expr = "($p).setCanDrinkLambda(() -> true)";
        DrlxExpression expression = DrlxParser.parseExpression(this.parser, (String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testModifyStatement() {
        String expr = "{ modify ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { name = \"Luca\", age = \"35\" };" + this.newLine() + "}");
    }

    @Test(expected=ParseProblemException.class)
    public void testModifyFailing() {
        String expr = "{ modify  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testModifyStatementSemicolon() {
        String expr = "{ modify ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { name = \"Luca\" };" + this.newLine() + "}");
    }

    @Test
    public void testModifySemiColon() {
        String expr = "{ modify($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { setAge(1) };" + this.newLine() + "}");
    }

    @Test
    public void testModifyMultiple() {
        String expr = "{ modify($p) { setAge(1)," + this.newLine() + " setAge(2), setAge(3)," + this.newLine() + "setAge(4); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { setAge(1), setAge(2), setAge(3), setAge(4) };" + this.newLine() + "}");
    }

    @Test
    public void testModifyEmptyBlock() {
        String expr = "{ modify( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($s) {  };" + this.newLine() + "}");
    }

    @Test
    public void testModifyWithoutSemicolon() {
        String expr = "{modify($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { setAge($p.getAge() + 1) };" + this.newLine() + "}");
    }

    @Test
    public void testModifyWithCast() {
        String expr = "{modify( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ((BooleanEvent) $toEdit.get(0)) {  };" + this.newLine() + "}");
    }

    @Test
    public void testWithStatement() {
        String expr = "{ with ( $p )  { name = \"Luca\", age = \"35\" }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ($p) { name = \"Luca\", age = \"35\" };" + this.newLine() + "}");
    }

    @Test(expected=ParseProblemException.class)
    public void testWithFailing() {
        String expr = "{ with  { name = \"Luca\", age = \"35\" }; }";
        MvelParser.parseBlock((String)expr);
    }

    @Test
    public void testWithStatementSemicolon() {
        String expr = "{ with ( $p )  { name = \"Luca\"; }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ($p) { name = \"Luca\" };" + this.newLine() + "}");
    }

    @Test
    public void testWithSemiColon() {
        String expr = "{ with($p) { setAge(1); }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ($p) { setAge(1) };" + this.newLine() + "}");
    }

    @Test
    public void testWithEmptyBlock() {
        String expr = "{ with( $s ) { } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ($s) {  };" + this.newLine() + "}");
    }

    @Test
    public void testWithWithoutSemicolon() {
        String expr = "{with($p) { setAge($p.getAge()+1) } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ($p) { setAge($p.getAge() + 1) };" + this.newLine() + "}");
    }

    @Test
    public void testWithWithCast() {
        String expr = "{with( (BooleanEvent)$toEdit.get(0) ){  }}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with ((BooleanEvent) $toEdit.get(0)) {  };" + this.newLine() + "}");
    }

    @Test
    public void testWithConstructor() {
        String expr = "{ with(s1 = new Some()) { }; }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    with (s1 = new Some()) {  };" + this.newLine() + "}");
    }

    @Test
    public void testWithoutSemicolon() {
        String expr = "{             a()" + this.newLine() + "b()" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    a();" + this.newLine() + "    b();" + this.newLine() + "}");
    }

    @Test
    public void testWithoutSemicolonMethod() {
        String expr = "{             delete($person)" + this.newLine() + "delete($pet)" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}");
    }

    @Test
    public void testWithoutSemicolonMethodComment() {
        String expr = "{             delete($person) // comment" + this.newLine() + "delete($pet) // comment " + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}");
    }

    @Test
    public void testWithoutSemicolonMethodCommentOppositeOSLineEndings() {
        String oppositeLineEnding = SystemUtils.IS_OS_WINDOWS ? "\n" : "\r\n";
        String expr = "{             delete($person) // comment" + oppositeLineEnding + "delete($pet) // comment" + oppositeLineEnding + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}");
    }

    @Test
    public void statementsWithComments() {
        String expr = "{             delete($person); // comment" + this.newLine() + "delete($pet); // comment " + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "    delete($pet);" + this.newLine() + "}");
    }

    @Test
    public void singleLineBlock() {
        String expr = "{ delete($person); } // comment ";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "}");
    }

    @Test
    public void singleLineBlockWithoutsemicolon() {
        String expr = "{ delete($person) } // comment";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    delete($person);" + this.newLine() + "}");
    }

    @Test
    public void commentsWithEmptyStatements() {
        String expr = "{// modify ; something" + this.newLine() + "/* modify ; something */" + this.newLine() + "setAge(47)" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    setAge(47);" + this.newLine() + "}");
    }

    @Test
    public void newLineInFunctionCall() {
        String expr = "{func(x " + this.newLine() + ")" + this.newLine() + "}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    func(x);" + this.newLine() + "}");
    }

    @Test
    public void newLineInFunctionCall2() {
        Expression expression = MvelParser.parseExpression((String)("func(x," + this.newLine() + " 2)"));
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("func(x, 2)");
    }

    @Test
    public void newLineInFunctionCall3() {
        Expression expression = MvelParser.parseExpression((String)("func(x" + this.newLine() + ", 2)"));
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("func(x, 2)");
    }

    @Test
    public void commentsWithEmptyStatements2() {
        String expr = "{  globalA.add(\"A\");" + this.newLine() + "  modify( $p ) {" + this.newLine() + "    // modify ; something" + this.newLine() + "    /* modify ; something */" + this.newLine() + "    setAge(47)" + this.newLine() + "  }" + this.newLine() + "  globalB.add(\"B\");" + this.newLine() + "  // modify ; something" + this.newLine() + "  /* modify ; something */}";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    globalA.add(\"A\");" + this.newLine() + "    modify ($p) { setAge(47) };" + this.newLine() + "    globalB.add(\"B\");" + this.newLine() + "}");
    }

    @Test
    public void testModifyLambda() {
        String expr = "{  modify($p) {  setCanDrinkLambda(() -> true); } }";
        BlockStmt expression = MvelParser.parseBlock((String)expr);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo("{" + this.newLine() + "    modify ($p) { setCanDrinkLambda(() -> true) };" + this.newLine() + "}");
    }

    @Test
    public void testNewExpression() {
        String expr = "money == new BigInteger(\"3\")";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testArrayCreation() {
        String expr = "new Object[] { \"getMessageId\", ($s != null ? $s : \"42103\") }";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testArrayCreation2() {
        String expr = "functions.arrayContainsInstanceWithParameters((Object[]) $f.getPersons())";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(expr);
    }

    @Test
    public void testSpecialNewlineHandling() {
        String expr = "{ a() \nprint(1) }";
        ((AbstractIntegerAssert)Assertions.assertThat((int)MvelParser.parseBlock((String)expr).getStatements().size()).as("There should be 2 statements", new Object[0])).isEqualTo(2);
        MvelParser mvelParser = new MvelParser(new ParserConfiguration(), false);
        ParseResult r = mvelParser.parse(GeneratedMvelParser::BlockParseStart, (Provider)new StringProvider(expr));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)r.isSuccessful()).as("Parsing should break at newline", new Object[0])).isFalse();
    }

    @Test
    public void testLineBreakAtTheEndOfStatementWithoutSemicolon() {
        String expr = "{  Person p2 = new Person(\"John\");\n  p2.age = 30\ninsert(p2);\n }";
        MvelParser mvelParser = new MvelParser(new ParserConfiguration(), true);
        ParseResult r = mvelParser.parse(GeneratedMvelParser::BlockParseStart, (Provider)new StringProvider(expr));
        BlockStmt blockStmt = (BlockStmt)r.getResult().get();
        ((AbstractIntegerAssert)Assertions.assertThat((int)blockStmt.getStatements().size()).as("Should parse 3 statements", new Object[0])).isEqualTo(3);
    }

    private void testMvelSquareOperator(String wholeExpression, String operator, String left, String right, boolean isNegated) {
        String expr = wholeExpression;
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assertions.assertThat((Object)expression).isInstanceOf(PointFreeExpr.class);
        Assertions.assertThat((String)PrintUtil.printNode((Node)expression)).isEqualTo(wholeExpression);
        PointFreeExpr e = (PointFreeExpr)expression;
        Assertions.assertThat((String)e.getOperator().asString()).isEqualTo(operator);
        Assertions.assertThat((String)this.toString((Node)e.getLeft())).isEqualTo(left);
        Assertions.assertThat((String)this.toString(e.getRight().get(0))).isEqualTo(right);
        Assertions.assertThat((boolean)e.isNegated()).isEqualTo(isNegated);
    }

    private String toString(Node n) {
        return PrintUtil.printNode((Node)n);
    }

    private String newLine() {
        return System.lineSeparator();
    }

    @Test
    public void testBindVariable() {
        String expr = "$n : name == \"Mark\"";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        SimpleName bind = drlxExpression.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$n");
        Expression expression = drlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mark\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testEnclosedBindVariable() {
        String expr = "($n : name == \"Mario\")";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression enclosedExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(enclosedExpr instanceof EnclosedExpr)).isTrue();
        Expression inner = ((EnclosedExpr)enclosedExpr).getInner();
        Assertions.assertThat((boolean)(inner instanceof DrlxExpression)).isTrue();
        DrlxExpression innerDrlxExpression = (DrlxExpression)inner;
        SimpleName bind = innerDrlxExpression.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$n");
        Expression expression = innerDrlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
    }

    @Test
    public void testComplexEnclosedBindVariable() {
        String expr = "($n : name == \"Mario\") && (age > 20)";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(bExpr instanceof BinaryExpr)).isTrue();
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assertions.assertThat((boolean)(left instanceof EnclosedExpr)).isTrue();
        Expression inner = ((EnclosedExpr)left).getInner();
        Assertions.assertThat((boolean)(inner instanceof DrlxExpression)).isTrue();
        DrlxExpression innerDrlxExpression = (DrlxExpression)inner;
        SimpleName bind = innerDrlxExpression.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$n");
        Expression expression = innerDrlxExpression.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assertions.assertThat((boolean)(right instanceof EnclosedExpr)).isTrue();
        Expression expression2 = ((EnclosedExpr)right).getInner();
        BinaryExpr binaryExpr2 = (BinaryExpr)expression2;
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getRight())).isEqualTo("20");
        Assertions.assertThat((Comparable)binaryExpr2.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
    }

    @Test
    public void testBindingOnRight() {
        String expr = "$n : name == \"Mario\" && $a : age > 20";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(bExpr instanceof BinaryExpr)).isTrue();
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assertions.assertThat((boolean)(left instanceof DrlxExpression)).isTrue();
        DrlxExpression leftExpr = (DrlxExpression)left;
        SimpleName leftBind = leftExpr.getBind();
        Assertions.assertThat((String)leftBind.asString()).isEqualTo("$n");
        Expression expression = leftExpr.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assertions.assertThat((boolean)(right instanceof DrlxExpression)).isTrue();
        DrlxExpression rightExpr = (DrlxExpression)right;
        SimpleName rightBind = rightExpr.getBind();
        Assertions.assertThat((String)rightBind.asString()).isEqualTo("$a");
        BinaryExpr binaryExpr2 = (BinaryExpr)rightExpr.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getRight())).isEqualTo("20");
        Assertions.assertThat((Comparable)binaryExpr2.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
    }

    @Test
    public void test3BindingOn3Conditions() {
        String expr = "$n : name == \"Mario\" && $a : age > 20 && $l : likes != null";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(bExpr instanceof BinaryExpr)).isTrue();
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assertions.assertThat((boolean)(left instanceof BinaryExpr)).isTrue();
        BinaryExpr leftExpr = (BinaryExpr)left;
        DrlxExpression first = (DrlxExpression)leftExpr.getLeft();
        DrlxExpression second = (DrlxExpression)leftExpr.getRight();
        DrlxExpression third = (DrlxExpression)((BinaryExpr)bExpr).getRight();
        SimpleName bind = first.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$n");
        BinaryExpr binaryExpr = (BinaryExpr)first.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        bind = second.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$a");
        binaryExpr = (BinaryExpr)second.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("20");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        bind = third.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$l");
        binaryExpr = (BinaryExpr)third.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("likes");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("null");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.NOT_EQUALS);
    }

    @Test
    public void testBindingOnRightWithOr() {
        String expr = "$n : name == \"Mario\" || $a : age > 20";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(bExpr instanceof BinaryExpr)).isTrue();
        Assertions.assertThat((((BinaryExpr)bExpr).getOperator() == BinaryExpr.Operator.OR ? 1 : 0) != 0).isTrue();
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assertions.assertThat((boolean)(left instanceof DrlxExpression)).isTrue();
        DrlxExpression leftExpr = (DrlxExpression)left;
        SimpleName leftBind = leftExpr.getBind();
        Assertions.assertThat((String)leftBind.asString()).isEqualTo("$n");
        Expression expression = leftExpr.getExpr();
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assertions.assertThat((boolean)(right instanceof DrlxExpression)).isTrue();
        DrlxExpression rightExpr = (DrlxExpression)right;
        SimpleName rightBind = rightExpr.getBind();
        Assertions.assertThat((String)rightBind.asString()).isEqualTo("$a");
        BinaryExpr binaryExpr2 = (BinaryExpr)rightExpr.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)binaryExpr2.getRight())).isEqualTo("20");
        Assertions.assertThat((Comparable)binaryExpr2.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
    }

    @Test
    public void test3BindingOn3ConditionsWithOrAnd() {
        String expr = "$n : name == \"Mario\" || $a : age > 20 && $l : likes != null";
        DrlxExpression drlxExpression = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression bExpr = drlxExpression.getExpr();
        Assertions.assertThat((boolean)(bExpr instanceof BinaryExpr)).isTrue();
        Assertions.assertThat((((BinaryExpr)bExpr).getOperator() == BinaryExpr.Operator.OR ? 1 : 0) != 0).isTrue();
        Expression left = ((BinaryExpr)bExpr).getLeft();
        Assertions.assertThat((boolean)(left instanceof DrlxExpression)).isTrue();
        Expression right = ((BinaryExpr)bExpr).getRight();
        Assertions.assertThat((boolean)(right instanceof BinaryExpr)).isTrue();
        BinaryExpr rightExpr = (BinaryExpr)right;
        Assertions.assertThat((rightExpr.getOperator() == BinaryExpr.Operator.AND ? 1 : 0) != 0).isTrue();
        DrlxExpression first = (DrlxExpression)left;
        DrlxExpression second = (DrlxExpression)rightExpr.getLeft();
        DrlxExpression third = (DrlxExpression)rightExpr.getRight();
        SimpleName bind = first.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$n");
        BinaryExpr binaryExpr = (BinaryExpr)first.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("name");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("\"Mario\"");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.EQUALS);
        bind = second.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$a");
        binaryExpr = (BinaryExpr)second.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("age");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("20");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.GREATER);
        bind = third.getBind();
        Assertions.assertThat((String)bind.asString()).isEqualTo("$l");
        binaryExpr = (BinaryExpr)third.getExpr();
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getLeft())).isEqualTo("likes");
        Assertions.assertThat((String)this.toString((Node)binaryExpr.getRight())).isEqualTo("null");
        Assertions.assertThat((Comparable)binaryExpr.getOperator()).isEqualTo((Object)BinaryExpr.Operator.NOT_EQUALS);
    }

    static {
        operators.addAll(Arrays.asList("after", "before", "in", "matches", "includes"));
    }
}

