/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitUtils;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.kie.api.runtime.rule.Variable;

public abstract class TraitProxyImpl
implements Externalizable,
TraitType,
Comparable<TraitProxyImpl>,
TraitProxy {
    protected TripleFactory tripleFactory;
    private BitSet typeCode;
    private BitSet propagationTypeCode = new BitSet();
    private Set<BitSet> otns;
    protected Map<String, Object> fields;

    public boolean _isVirtual() {
        return false;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    protected void setFields(Map<String, Object> m) {
        this.fields = m;
    }

    public abstract String _getTraitName();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fields);
        out.writeObject(this.tripleFactory);
        out.writeObject(this.typeCode);
        out.writeObject(this.otns);
        out.writeObject(this.propagationTypeCode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fields = (Map)in.readObject();
        this.tripleFactory = (TripleFactory)in.readObject();
        this.typeCode = (BitSet)in.readObject();
        this.otns = (Set)in.readObject();
        this.propagationTypeCode = (BitSet)in.readObject();
    }

    public static Map.Entry<String, Object> buildEntry(final String k, final Object v) {
        return new Map.Entry<String, Object>(){
            private String key;
            private Object obj;
            {
                this.key = k;
                this.obj = v;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.obj;
            }

            @Override
            public Object setValue(Object value) {
                this.obj = value;
                return value;
            }

            public String toString() {
                return "<<" + this.key + "=" + this.obj + ">>";
            }
        };
    }

    public abstract TraitableBean getObject();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getObject().equals(((TraitProxyImpl)o).getObject());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getObject().hashCode();
    }

    protected Triple propertyKey(String property) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property, (Object)Variable.v);
    }

    protected Triple property(String property, Object value) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property, value);
    }

    protected Triple propertyKey(Object property) {
        return this.getTripleFactory().newTriple((Object)this.getObject(), property.toString(), (Object)Variable.v);
    }

    public TripleFactory getTripleFactory() {
        return this.tripleFactory;
    }

    public void setTripleFactory(TripleFactory tripleFactory) {
        this.tripleFactory = tripleFactory;
    }

    public BitSet _getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(BitSet typeCode) {
        this.typeCode = typeCode;
    }

    public void shed() {
    }

    @Override
    public int compareTo(TraitProxyImpl o) {
        if (TraitUtils.supersetOrEqualset((BitSet)this.typeCode, (BitSet)o.typeCode)) {
            return -1;
        }
        return 1;
    }

    public BitSet computeInsertionVetoMask() {
        BitSet typeMask = new BitSet();
        for (Object o : this.getObject()._getTraitMap().values()) {
            if (o == this) continue;
            typeMask.or(((TraitProxyImpl)o).propagationTypeCode);
        }
        return typeMask;
    }

    public void assignOtn(BitSet typeCode) {
        if (this.otns == null) {
            this.otns = new HashSet<BitSet>();
        }
        this.otns.add(typeCode);
        this.propagationTypeCode.or(typeCode);
    }

    public boolean hasOtns() {
        return this.otns != null && !this.otns.isEmpty();
    }

    public void clearOtns() {
        if (this.otns != null) {
            this.otns.clear();
        }
        this.propagationTypeCode.clear();
    }

    public Set<BitSet> listAssignedOtnTypeCodes() {
        return this.otns != null ? Collections.unmodifiableSet(this.otns) : Collections.EMPTY_SET;
    }

    public boolean _hasTypeCode(BitSet typeCode) {
        if (this.otns == null) {
            return false;
        }
        return this.otns.contains(typeCode);
    }
}

