/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.enums.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.enums.client.editor.EnumEditorView;
import org.drools.workbench.screens.enums.client.editor.EnumParser;
import org.drools.workbench.screens.enums.client.editor.EnumRow;
import org.drools.workbench.screens.enums.client.type.EnumResourceType;
import org.drools.workbench.screens.enums.model.EnumModelContent;
import org.drools.workbench.screens.enums.service.EnumService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="EnumEditor", supportedTypes={EnumResourceType.class})
public class EnumEditorPresenter
extends KieEditor {
    private EnumEditorView view;
    private Caller<EnumService> enumService;
    private EnumResourceType type;
    private ValidationPopup validationPopup;

    public EnumEditorPresenter() {
    }

    @Inject
    public EnumEditorPresenter(EnumEditorView baseView, Caller<EnumService> enumService, EnumResourceType type, ValidationPopup validationPopup) {
        super((KieEditorView)baseView);
        this.view = baseView;
        this.enumService = enumService;
        this.type = type;
        this.validationPopup = validationPopup;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((EnumService)this.enumService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<EnumModelContent> getModelSuccessCallback() {
        return new RemoteCallback<EnumModelContent>(){

            public void callback(EnumModelContent content) {
                if (EnumEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                EnumEditorPresenter.this.resetEditorPages(content.getOverview());
                EnumEditorPresenter.this.addSourcePage();
                List<EnumRow> enumDefinitions = EnumParser.fromString(content.getModel().getEnumDefinitions());
                EnumEditorPresenter.this.view.setContent(enumDefinitions);
                EnumEditorPresenter.this.view.hideBusyIndicator();
                EnumEditorPresenter.this.createOriginalHash(enumDefinitions);
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((EnumService)EnumEditorPresenter.this.enumService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            EnumEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            EnumEditorPresenter.this.validationPopup.showMessages(results);
                        }
                    }
                })).validate((Path)EnumEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)EnumParser.toString(EnumEditorPresenter.this.view.getContent()));
            }
        };
    }

    protected void save(String commitMessage) {
        List<EnumRow> content = this.view.getContent();
        ((EnumService)this.enumService.call(this.getSaveSuccessCallback(content.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)EnumParser.toString(content), this.metadata, commitMessage);
    }

    public void onSourceTabSelected() {
        this.updateSource(EnumParser.toString(this.view.getContent()));
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose(this.view.getContent());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

