/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache.inspectors;

import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.action.ActionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.action.ActionInspectorFactory;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionInspectorFactory;
import org.drools.workbench.services.verifier.api.client.cache.util.HasConflicts;
import org.drools.workbench.services.verifier.api.client.cache.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.cache.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.UpdatableInspectorList;
import org.drools.workbench.services.verifier.api.client.checks.util.Conflict;
import org.drools.workbench.services.verifier.api.client.checks.util.HumanReadable;
import org.drools.workbench.services.verifier.api.client.checks.util.IsConflicting;
import org.drools.workbench.services.verifier.api.client.checks.util.IsRedundant;
import org.drools.workbench.services.verifier.api.client.checks.util.IsSubsuming;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.select.AllListener;
import org.uberfire.commons.validation.PortablePreconditions;

public class FieldInspector
implements HasConflicts,
IsConflicting,
IsSubsuming,
IsRedundant,
HumanReadable,
HasKeys {
    private final ObjectField objectField;
    private final UpdatableInspectorList<ActionInspector, Action> actionInspectorList;
    private final UpdatableInspectorList<ConditionInspector, Condition> conditionInspectorList;
    private final UUIDKey uuidKey;
    private final RuleInspectorUpdater ruleInspectorUpdater;

    public FieldInspector(Field field, RuleInspectorUpdater ruleInspectorUpdater, AnalyzerConfiguration configuration) {
        this(field.getObjectField(), ruleInspectorUpdater, configuration);
        configuration.getUUID(this);
        this.updateActionInspectors(field.getActions().where(Action.value().any()).select().all());
        this.updateConditionInspectors(field.getConditions().where(Condition.value().any()).select().all());
        this.setupActionsListener(field);
        this.setupConditionsListener(field);
    }

    public FieldInspector(ObjectField field, RuleInspectorUpdater ruleInspectorUpdater, AnalyzerConfiguration configuration) {
        this.objectField = (ObjectField)PortablePreconditions.checkNotNull((String)"field", (Object)field);
        this.ruleInspectorUpdater = (RuleInspectorUpdater)PortablePreconditions.checkNotNull((String)"ruleInspectorUpdater", (Object)ruleInspectorUpdater);
        this.uuidKey = configuration.getUUID(this);
        this.actionInspectorList = new UpdatableInspectorList<ActionInspector, Action>(new ActionInspectorFactory(configuration), configuration);
        this.conditionInspectorList = new UpdatableInspectorList<ConditionInspector, Condition>(new ConditionInspectorFactory(configuration), configuration);
    }

    private void setupConditionsListener(Field field) {
        field.getConditions().where(Condition.value().any()).listen().all(new AllListener<Condition>(){

            @Override
            public void onAllChanged(Collection<Condition> all) {
                FieldInspector.this.updateConditionInspectors(all);
                FieldInspector.this.ruleInspectorUpdater.resetConditionsInspectors();
            }
        });
    }

    private void setupActionsListener(Field field) {
        field.getActions().where(Action.value().any()).listen().all(new AllListener<Action>(){

            @Override
            public void onAllChanged(Collection<Action> all) {
                FieldInspector.this.updateActionInspectors(all);
                FieldInspector.this.ruleInspectorUpdater.resetActionsInspectors();
            }
        });
    }

    public ObjectField getObjectField() {
        return this.objectField;
    }

    private void updateConditionInspectors(Collection<Condition> all) {
        this.conditionInspectorList.update(all);
    }

    private void updateActionInspectors(Collection<Action> all) {
        this.actionInspectorList.update(all);
    }

    public InspectorList<ActionInspector> getActionInspectorList() {
        return this.actionInspectorList;
    }

    public InspectorList<ConditionInspector> getConditionInspectorList() {
        return this.conditionInspectorList;
    }

    @Override
    public Conflict hasConflicts() {
        int index = 1;
        for (ConditionInspector conditionInspector : this.conditionInspectorList) {
            for (int j = index; j < this.conditionInspectorList.size(); ++j) {
                if (!conditionInspector.conflicts(this.conditionInspectorList.get(j))) continue;
                return new Conflict(conditionInspector, (HasUUID)this.conditionInspectorList.get(j));
            }
            ++index;
        }
        return Conflict.EMPTY;
    }

    public boolean conflicts(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            boolean conflicting = this.actionInspectorList.conflicts(((FieldInspector)other).actionInspectorList);
            if (conflicting) {
                return true;
            }
            return this.conditionInspectorList.conflicts(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            return this.actionInspectorList.isRedundant(((FieldInspector)other).actionInspectorList) && this.conditionInspectorList.isRedundant(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof FieldInspector && this.objectField.equals(((FieldInspector)other).objectField)) {
            return this.actionInspectorList.subsumes(((FieldInspector)other).actionInspectorList) && this.conditionInspectorList.subsumes(((FieldInspector)other).conditionInspectorList);
        }
        return false;
    }

    @Override
    public String toHumanReadableString() {
        return this.objectField.getName();
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

