/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache.util.maps;

import java.util.ArrayList;
import org.drools.workbench.services.verifier.api.client.cache.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.cache.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.checks.util.IsConflicting;
import org.drools.workbench.services.verifier.api.client.checks.util.IsOverlapping;
import org.drools.workbench.services.verifier.api.client.checks.util.IsRedundant;
import org.drools.workbench.services.verifier.api.client.checks.util.IsSubsuming;
import org.drools.workbench.services.verifier.api.client.checks.util.RelationResolver;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;

public class InspectorList<InspectorType extends HasUUID>
extends ArrayList<InspectorType>
implements IsOverlapping,
IsSubsuming<InspectorList>,
IsRedundant<InspectorList>,
IsConflicting<InspectorList>,
HasKeys {
    private final UUIDKey uuidKey;
    private final RelationResolver relationResolver;

    public InspectorList(AnalyzerConfiguration configuration) {
        this(false, configuration);
    }

    public InspectorList(boolean record, AnalyzerConfiguration configuration) {
        this.relationResolver = new RelationResolver(this, record);
        this.uuidKey = configuration.getUUID(this);
    }

    @Override
    public boolean overlaps(Object other) {
        return false;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    @Override
    public boolean conflicts(InspectorList other) {
        return this.relationResolver.isConflicting(other);
    }

    @Override
    public boolean isRedundant(InspectorList other) {
        return this.relationResolver.isRedundant(other);
    }

    @Override
    public boolean subsumes(InspectorList other) {
        return this.relationResolver.subsumes(other);
    }

    @Override
    public boolean add(InspectorType inspector) {
        return super.add(inspector);
    }
}

