/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.services.verifier.api.client.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.checks.base.OneToManyCheck;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.NoteBuilder;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class DetectDeficientRowsCheck
extends OneToManyCheck {
    public DetectDeficientRowsCheck(final RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, new RuleInspectorCache.Filter(){

            @Override
            public boolean accept(RuleInspector other) {
                return !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey()) && !other.isEmpty();
            }
        }, configuration);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.isEmpty()) {
            return;
        }
        if (this.ruleInspector.atLeastOneConditionHasAValue() && this.thereIsAtLeastOneRow()) {
            this.hasIssues = this.isDeficient();
        }
    }

    private boolean isDeficient() {
        for (RuleInspector other : this.getOtherRows()) {
            if (this.isDeficient(other)) continue;
            return false;
        }
        return true;
    }

    private boolean isDeficient(RuleInspector other) {
        return this.ruleInspector.isDeficient(other);
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, AnalysisConstants.INSTANCE.DeficientRow(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return ((Explanation)((NoteBuilder)new Explanation().addParagraph(AnalysisConstants.INSTANCE.DeficientRowsP1()).startNote().addParagraph(AnalysisConstants.INSTANCE.DeficientRowsNoteP1()).startExampleTable().startHeader().headerConditions(AnalysisConstants.INSTANCE.Salary(), AnalysisConstants.INSTANCE.Savings()).headerActions(AnalysisConstants.INSTANCE.ApproveLoan()).end().startRow().addConditions("--", "100 000").addActions("true").end().startRow().addConditions("30 000", "--").addActions("false").end().end()).end()).addParagraph(AnalysisConstants.INSTANCE.DeficientRowsP2()).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }
}

