/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks.util;

import java.util.Iterator;
import org.drools.workbench.services.verifier.api.client.cache.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.checks.util.Conflict;
import org.drools.workbench.services.verifier.api.client.checks.util.Conflicts;
import org.drools.workbench.services.verifier.api.client.checks.util.IsConflicting;

public class ConflictResolver {
    private final InspectorList collection;
    private final Conflicts conflicts;

    public ConflictResolver(InspectorList list, boolean record) {
        this.collection = list;
        this.conflicts = new Conflicts(record);
    }

    private Conflict isConflicting(InspectorList otherCollection) {
        if (this.collection == null || otherCollection == null) {
            return Conflict.EMPTY;
        }
        for (Object o : this.collection) {
            Conflict conflict;
            if (!(o instanceof IsConflicting) || !(conflict = ConflictResolver.hasConflictingObjectInList(otherCollection, (IsConflicting)o)).foundIssue()) continue;
            return new Conflict(this.collection, otherCollection, conflict);
        }
        return Conflict.EMPTY;
    }

    private static Conflict getConflictingObjects(InspectorList collection, IsConflicting isConflicting) {
        if (isConflicting == null || collection == null) {
            return Conflict.EMPTY;
        }
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            Object other = iterator.next();
            return ConflictResolver.isConflicting(isConflicting, (HasUUID)other);
        }
        return Conflict.EMPTY;
    }

    private static Conflict hasConflictingObjectInList(InspectorList collection, IsConflicting isConflicting) {
        return ConflictResolver.getConflictingObjects(collection, isConflicting);
    }

    static Conflict isConflicting(HasUUID isConflicting, HasUUID other) {
        if (isConflicting instanceof IsConflicting && ((IsConflicting)isConflicting).conflicts(other)) {
            return new Conflict(isConflicting, other);
        }
        return Conflict.EMPTY;
    }

    public Conflict resolveConflict(InspectorList otherCollection) {
        Conflict first = this.conflicts.get(otherCollection.getUuidKey());
        if (first != null) {
            if (first.doesRelationStillExist()) {
                return first;
            }
            this.conflicts.remove(first);
            return this.resolveConflict(otherCollection);
        }
        Conflict conflict = this.isConflicting(otherCollection);
        if (conflict.foundIssue()) {
            this.conflicts.add(conflict);
            return conflict;
        }
        return Conflict.EMPTY;
    }
}

