/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index.keys;

import java.util.ArrayList;
import org.drools.workbench.services.verifier.api.client.cache.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.RetractHandler;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;

public class UUIDKey
extends Key {
    public static final KeyDefinition UNIQUE_UUID = KeyDefinition.newKeyDefinition().withId("unique---uuid").build();
    private ArrayList<RetractHandler> retractHandlers = new ArrayList();
    private HasKeys hasKeys;

    UUIDKey(HasKeys hasKeys, String uuid) {
        super(UNIQUE_UUID, (Comparable)((Object)uuid));
        this.hasKeys = hasKeys;
    }

    public static UUIDKey getUUIDKey(Key[] keys) {
        UUIDKey result = null;
        for (Key key : keys) {
            if (!(key instanceof UUIDKey)) continue;
            if (result == null) {
                result = (UUIDKey)key;
                continue;
            }
            throw new IllegalArgumentException("You can only have one uuid key.");
        }
        if (result == null) {
            throw new IllegalArgumentException("You must set a uuid key.");
        }
        return result;
    }

    public void retract() {
        for (RetractHandler retractHandler : this.retractHandlers) {
            retractHandler.retract(this);
        }
    }

    public void addRetractHandler(RetractHandler retractHandler) {
        this.retractHandlers.add(retractHandler);
    }

    public Key[] getKeys() {
        return this.hasKeys.keys();
    }

    @Override
    public int compareTo(Key key) {
        return this.getSingleValue().compareTo(key.getSingleValue());
    }
}

