/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.RequestBodyWriter;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.http.client.HttpClient;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.eclipse.webdav.internal.utils.URLEncoder;
import org.w3c.dom.Document;

public class RemoteDAVClient
extends DAVClient {
    protected HttpClient httpClient = null;

    public RemoteDAVClient(RemoteDAVClient davClient) {
        super(davClient);
    }

    public RemoteDAVClient(WebDAVFactory webDAVFactory, HttpClient httpClient) {
        super(webDAVFactory);
        this.httpClient = httpClient;
    }

    @Override
    public IResponse baselineControl(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "BASELINE-CONTROL");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse bind(ILocator source, ILocator destination, IContext userContext) throws IOException {
        Assert.isNotNull(source);
        Assert.isNotNull(destination);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, source);
        context.setDestination(URLEncoder.encode(destination.getResourceURL()));
        Request request = this.newRequest(source, context, "BIND");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse checkin(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "CHECKIN");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse checkout(ILocator locator, IContext userContext, Document body) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, body, "CHECKOUT");
        return this.httpClient.invoke(request);
    }

    @Override
    protected Object clone() {
        return new RemoteDAVClient(this);
    }

    @Override
    public void close() {
        this.httpClient.close();
        super.close();
    }

    @Override
    public IResponse copy(ILocator source, ILocator destination, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(source);
        Assert.isNotNull(destination);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, source);
        context.setDestination(URLEncoder.encode(destination.getResourceURL()));
        Request request = this.newRequest(source, context, document, "COPY");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse delete(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "DELETE");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse get(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "GET");
        return this.httpClient.invoke(request);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public IResponse head(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "HEAD");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse label(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(document);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "LABEL");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse lock(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "LOCK");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse merge(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(document);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "MERGE");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse mkactivity(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "MKACTIVITY");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse mkcol(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "MKCOL");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse mkworkspace(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "MKWORKSPACE");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse move(ILocator source, ILocator destination, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(source);
        Assert.isNotNull(destination);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, source);
        context.setDestination(URLEncoder.encode(destination.getResourceURL()));
        Request request = this.newRequest(source, context, document, "MOVE");
        return this.httpClient.invoke(request);
    }

    private Request newRequest(ILocator locator, IContext context, InputStream is, String methodName) throws IOException {
        return new Request(methodName, URLEncoder.encode(new URL(locator.getResourceURL())), context, is);
    }

    private Request newRequest(ILocator locator, IContext context, String methodName) throws IOException {
        return new Request(methodName, URLEncoder.encode(new URL(locator.getResourceURL())), context);
    }

    private Request newRequest(ILocator locator, IContext context, Document document, String methodName) throws IOException {
        context.setContentType("text/xml; charset=\"UTF8\"");
        if (document == null) {
            return new Request(methodName, URLEncoder.encode(new URL(locator.getResourceURL())), context);
        }
        RequestBodyWriter writer = new RequestBodyWriter(document, "UTF8");
        return new Request(methodName, URLEncoder.encode(new URL(locator.getResourceURL())), context, writer);
    }

    @Override
    public IResponse options(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "OPTIONS");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse post(ILocator locator, IContext userContext, InputStream is) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(is);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, is, "POST");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse propfind(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "PROPFIND");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse proppatch(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(document);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "PROPPATCH");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse put(ILocator locator, IContext userContext, InputStream is) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(is);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, is, "PUT");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse report(ILocator locator, IContext userContext, Document document) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        Assert.isNotNull(document);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, document, "REPORT");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse trace(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "TRACE");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse uncheckout(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "UNCHECKOUT");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse unlock(ILocator locator, IContext userContext) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, "UNLOCK");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse update(ILocator locator, IContext userContext, Document body) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, body, "UPDATE");
        return this.httpClient.invoke(request);
    }

    @Override
    public IResponse versionControl(ILocator locator, IContext userContext, Document body) throws IOException {
        Assert.isNotNull(locator);
        Assert.isNotNull(userContext);
        IContext context = this.newContext(userContext, locator);
        Request request = this.newRequest(locator, context, body, "VERSION-CONTROL");
        return this.httpClient.invoke(request);
    }
}

