/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Prop;
import org.eclipse.webdav.dom.Status;
import org.w3c.dom.Element;

public class PropStat
extends ElementEditor {
    protected static final String[] childNames = new String[]{"prop", "status", "responsedescription"};

    public PropStat(Element root) throws MalformedElementException {
        super(root, "propstat");
    }

    public Prop getProp() throws MalformedElementException {
        Element prop = PropStat.getFirstChild(this.root, "prop");
        PropStat.ensureNotNull(Policy.bind("ensure.missingPropElmt"), prop);
        return new Prop(prop);
    }

    public String getResponseDescription() throws MalformedElementException {
        return PropStat.getChildText(this.root, "responsedescription", false);
    }

    public String getStatus() throws MalformedElementException {
        String status = PropStat.getChildText(this.root, "status", false);
        PropStat.ensureNotNull(Policy.bind("ensure.missingStatusElmt"), status);
        return status;
    }

    public int getStatusCode() throws MalformedElementException {
        return new Status(this.getStatus()).getStatusCode();
    }

    public Prop setProp() {
        Element prop = PropStat.setChild(this.root, "prop", childNames, true);
        try {
            return new Prop(prop);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public void setResponseDescription(String value) {
        if (value == null) {
            Element child = PropStat.getLastChild(this.root, "responsedescription");
            if (child != null) {
                this.root.removeChild(child);
            }
        } else {
            PropStat.setChild(this.root, "responsedescription", value, childNames, false);
        }
    }

    public void setStatus(String status) {
        Assert.isNotNull(status);
        PropStat.setChild(this.root, "status", status, childNames, true);
    }
}

