/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.utils;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.AuthenticationPromptDialog;
import org.guvnor.tools.utils.StringInput;
import org.guvnor.tools.utils.StringStorage;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.utils.webdav.WebDavSessionAuthenticator;
import org.guvnor.tools.views.RepositoryView;
import org.guvnor.tools.views.ResourceHistoryView;

public class PlatformUtils {
    private static PlatformUtils instance;

    public static PlatformUtils getInstance() {
        if (instance == null) {
            instance = new PlatformUtils();
        }
        return instance;
    }

    public static IFile getResourceFromFSPath(String location) {
        return Activator.getDefault().getWorkspace().getRoot().getFileForLocation((IPath)new Path(location));
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        return composite;
    }

    public static void updateDecoration() {
        final IWorkbench workbench = Activator.getDefault().getWorkbench();
        workbench.getDisplay().syncExec(new Runnable(){

            public void run() {
                IDecoratorManager manager = workbench.getDecoratorManager();
                manager.update("org.guvnor.tools.decorator");
            }
        });
    }

    public static void refreshRepositoryView() {
        IWorkbenchWindow activeWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return;
        }
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page == null) {
            return;
        }
        RepositoryView view = (RepositoryView)page.findView("org.guvnor.tools.views.RepositoryView");
        if (view != null) {
            view.refresh();
        }
    }

    public static ResourceHistoryView getResourceHistoryView() throws Exception {
        IWorkbenchWindow activeWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page == null) {
            return null;
        }
        return (ResourceHistoryView)page.showView("org.guvnor.tools.views.ResourceHistoryView");
    }

    public static void openEditor(String contents, String name) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StringStorage storage = new StringStorage(contents, name);
        StringInput input = new StringInput(storage);
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(name);
        String editorId = desc != null ? desc.getId() : "org.eclipse.ui.DefaultTextEditor";
        try {
            if (page != null) {
                page.openEditor((IEditorInput)input, editorId);
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public static Table createResourceHistoryTable(Composite parent) {
        int style = 101124;
        Table table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setResizable(true);
        column.setText(Messages.getString("history.revision"));
        column.setWidth(100);
        column = new TableColumn(table, 16384, 1);
        column.setResizable(true);
        column.setText(Messages.getString("history.date"));
        column.setWidth(175);
        column = new TableColumn(table, 16384, 2);
        column.setResizable(true);
        column.setText(Messages.getString("history.author"));
        column.setWidth(200);
        column = new TableColumn(table, 0x1000000, 3);
        column.setResizable(true);
        column.setText(Messages.getString("history.comment"));
        column.setWidth(350);
        return table;
    }

    public boolean authenticateForServer(String server, IWebDavClient client) throws Exception {
        AuthPromptResults res = this.promptForAuthentication(server);
        if (res != null) {
            if (res.wasSaved()) {
                Platform.addAuthorizationInfo((URL)new URL(server), (String)"", (String)"basic", res.getAuthInfo());
            } else {
                WebDavSessionAuthenticator authen = new WebDavSessionAuthenticator();
                authen.addAuthenticationInfo(new URL(server), "", "basic", res.getAuthInfo());
                client.setSessionAuthenticator(authen);
            }
            return true;
        }
        return false;
    }

    public void updateAuthentication(String server, String username, String password, boolean saveInfo) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("username", username);
        info.put("password", password);
        URL serverUrl = new URL(server);
        IWebDavClient client = WebDavServerCache.getWebDavClient(server);
        if (client == null) {
            client = WebDavClientFactory.createClient(serverUrl);
            WebDavServerCache.cacheWebDavClient(server, client);
        }
        if (saveInfo) {
            Platform.flushAuthorizationInfo((URL)serverUrl, (String)"", (String)"basic");
            Platform.addAuthorizationInfo((URL)serverUrl, (String)"", (String)"basic", info);
        } else {
            WebDavSessionAuthenticator authen = new WebDavSessionAuthenticator();
            authen.addAuthenticationInfo(new URL(server), "", "basic", info);
            client.setSessionAuthenticator(authen);
        }
    }

    public static void reportAuthenticationFailure() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                Shell shell = display.getActiveShell();
                MessageDialog.openError((Shell)shell, (String)Messages.getString("login.failure.dialog.caption"), (String)Messages.getString("login.failure.dialog.message"));
            }
        });
    }

    public AuthPromptResults promptForAuthentication(String server) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        AuthPromptRunnable op = new AuthPromptRunnable(server);
        display.syncExec((Runnable)op);
        return op.getResults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthPromptResults {
        private Map<String, String> info;
        private boolean saved;

        public AuthPromptResults(Map<String, String> info, boolean saved) {
            this.info = info;
            this.saved = saved;
        }

        public Map<String, String> getAuthInfo() {
            return this.info;
        }

        public boolean wasSaved() {
            return this.saved;
        }
    }

    class AuthPromptRunnable
    implements Runnable {
        AuthPromptResults res = null;
        private String server;

        public AuthPromptRunnable(String server) {
            this.server = server;
        }

        public void run() {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            AuthenticationPromptDialog diag = new AuthenticationPromptDialog(shell, this.server);
            if (diag.open() == 0) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("username", diag.getUserName());
                info.put("password", diag.getPassword());
                this.res = new AuthPromptResults(info, diag.saveAuthenInfo());
            }
        }

        public AuthPromptResults getResults() {
            return this.res;
        }
    }
}

