/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;

public class KieServerConfig {
    private String id;
    private String host;
    @JsonIgnore
    private CredentialsProvider credentialsProvider;
    @JsonIgnore
    private KieServicesClient client;

    public String getId() {
        if (this.client == null) {
            return null;
        }
        try {
            if (this.id == null) {
                ServiceResponse info = this.client.getServerInfo();
                this.id = ((KieServerInfo)info.getResult()).getServerId();
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.id;
    }

    public KieServerConfig setId(String id) {
        this.id = id;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public KieServerConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public KieServerConfig setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public KieServicesClient getClient() {
        return this.client;
    }

    public KieServerConfig setClient(KieServicesClient client) {
        this.client = client;
        return this;
    }

    public String getStatus() {
        if (this.client == null) {
            return "UNKNOWN";
        }
        try {
            return this.client.getServerInfo().getType().name();
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KieServerConfig [id=").append(this.id).append(", host=").append(this.host).append(", status=").append(this.getStatus()).append("]");
        return builder.toString();
    }
}

