/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="plans")
@SequenceGenerator(name="planIdSeq", sequenceName="PLAN_ID_SEQ")
@NamedQueries(value={@NamedQuery(name="Plan.findAll", query="SELECT p FROM Plan p"), @NamedQuery(name="Plan.findById", query="SELECT p FROM Plan p WHERE p.id = :id")})
public class Plan
implements Serializable {
    private static final long serialVersionUID = 1244535648642365858L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="planIdSeq")
    private long id;
    private String name;
    private String description;
    @Column(name="source_container_id")
    private String sourceContainerId;
    @Column(name="source_process_id")
    private String sourceProcessId;
    @Column(name="target_container_id")
    private String targetContainerId;
    @Column(name="target_process_id")
    private String targetProcessId;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="source")
    @Column(name="target")
    @CollectionTable(name="plan_mappings", joinColumns={@JoinColumn(name="plan_id")})
    private Map<String, String> mappings;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceContainerId() {
        return this.sourceContainerId;
    }

    public void setSourceContainerId(String sourceContainerId) {
        this.sourceContainerId = sourceContainerId;
    }

    public String getSourceProcessId() {
        return this.sourceProcessId;
    }

    public void setSourceProcessId(String sourceProcessId) {
        this.sourceProcessId = sourceProcessId;
    }

    public String getTargetContainerId() {
        return this.targetContainerId;
    }

    public void setTargetContainerId(String targetContainerId) {
        this.targetContainerId = targetContainerId;
    }

    public String getTargetProcessId() {
        return this.targetProcessId;
    }

    public void setTargetProcessId(String targetProcessId) {
        this.targetProcessId = targetProcessId;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Plan copy(Plan plan) {
        this.name = plan.getName();
        this.description = plan.getDescription();
        this.sourceContainerId = plan.getSourceContainerId();
        this.sourceProcessId = plan.getSourceProcessId();
        this.targetContainerId = plan.getTargetContainerId();
        this.targetProcessId = plan.getTargetProcessId();
        this.mappings = plan.getMappings();
        return this;
    }
}

