/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.kie.processmigration.model.Execution;
import org.kie.processmigration.model.Migration;
import org.kie.processmigration.model.exceptions.InvalidMigrationException;
import org.kie.processmigration.service.MigrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Startup
@Singleton
public class RecoveryService {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryService.class);
    private static final List<Execution.ExecutionStatus> PENDING_STATUSES = Arrays.asList(Execution.ExecutionStatus.STARTED, Execution.ExecutionStatus.CREATED);
    @PersistenceContext
    private EntityManager em;
    @Inject
    MigrationService migrationService;

    @PostConstruct
    public void resumeMigrations() {
        logger.info("Resuming ongoing migrations ...");
        TypedQuery query = this.em.createNamedQuery("Migration.findByStatus", Migration.class);
        query.setParameter("statuses", (Object)PENDING_STATUSES);
        query.getResultList().forEach(m -> {
            try {
                this.migrationService.migrate(m);
            }
            catch (InvalidMigrationException e) {
                logger.warn("Unable to resume migration with id: " + m.getId(), (Throwable)e);
            }
        });
    }
}

