/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

class DAVBitstream
extends DAVDSpaceObject {
    private static Logger log = Logger.getLogger(DAVBitstream.class);
    private Item item = null;
    private Bitstream bitstream = null;
    private static final int BITSTREAM_INLINE_THRESHOLD = 2000;
    private static final Element getcontentlengthProperty = new Element("getcontentlength", DAV.NS_DAV);
    private static final Element getcontenttypeProperty = new Element("getcontenttype", DAV.NS_DAV);
    private static final Element sourceProperty = new Element("source", DAV.NS_DSPACE);
    private static final Element descriptionProperty = new Element("description", DAV.NS_DSPACE);
    private static final Element formatProperty = new Element("format", DAV.NS_DSPACE);
    private static final Element format_descriptionProperty = new Element("format_description", DAV.NS_DSPACE);
    private static final Element checksumProperty = new Element("checksum", DAV.NS_DSPACE);
    private static final Element checksum_algorithmProperty = new Element("checksum_algorithm", DAV.NS_DSPACE);
    private static final Element sequence_idProperty = new Element("sequence_id", DAV.NS_DSPACE);
    private static final Element bundleProperty = new Element("bundle", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    protected DAVBitstream(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, Bitstream bitstream) {
        super(context, request, response, pathElt, (DSpaceObject)bitstream);
        this.bitstream = bitstream;
        this.type = 1;
    }

    protected DAVBitstream(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, Item item, Bitstream bitstream) {
        super(context, request, response, pathElt, (DSpaceObject)bitstream);
        this.bitstream = bitstream;
        this.type = 1;
        this.item = item;
    }

    protected static String getPathElt(int sid, String ext) {
        return "bitstream_" + String.valueOf(sid) + (ext == null ? "" : "." + ext);
    }

    protected static Bitstream findBitstream(Context context, Item item, String pathElt) throws SQLException, DAVStatusException {
        try {
            int dot = pathElt.indexOf(46);
            String strId = dot >= 0 ? pathElt.substring(0, dot) : pathElt;
            Bitstream result = null;
            if (strId.startsWith("bitstream_")) {
                strId = strId.substring(10);
                result = DAVBitstream.getBitstreamBySequenceID(item, Integer.parseInt(strId));
            } else if (strId.startsWith("retrieve_")) {
                strId = strId.substring(9);
                result = Bitstream.find((Context)context, (int)Integer.parseInt(strId));
            } else {
                throw new DAVStatusException(400, "Unrecognized bitstream URI format.");
            }
            if (result == null) {
                throw new DAVStatusException(404, "No bitstream at this sequence ID: " + pathElt);
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new DAVStatusException(400, "Invalid Bitstream Sequence ID in URI: " + pathElt, nfe);
        }
    }

    protected static Bitstream getBitstreamBySequenceID(Item item, int sid) throws SQLException {
        Bundle[] bundles;
        for (Bundle element : bundles = item.getBundles()) {
            Bitstream[] bitstreams;
            for (Bitstream element0 : bitstreams = element.getBitstreams()) {
                if (sid != element0.getSequenceID()) continue;
                return element0;
            }
        }
        return null;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        return new DAVResource[0];
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        AuthorizeManager.authorizeAction((Context)this.context, (DSpaceObject)this.bitstream, (int)0);
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = this.bitstream.getName();
            if (value == null) {
                value = this.makeDisplayname();
            }
        } else if (this.elementsEqualIsh(property, getcontentlengthProperty)) {
            value = String.valueOf(this.bitstream.getSize());
        } else if (this.elementsEqualIsh(property, getcontenttypeProperty)) {
            value = this.bitstream.getFormat().getMIMEType();
        } else if (this.elementsEqualIsh(property, sourceProperty)) {
            value = this.bitstream.getSource();
        } else if (this.elementsEqualIsh(property, descriptionProperty)) {
            value = this.bitstream.getDescription();
        } else if (this.elementsEqualIsh(property, formatProperty)) {
            BitstreamFormat bsf = this.bitstream.getFormat();
            value = bsf == null ? null : bsf.getShortDescription();
        } else if (this.elementsEqualIsh(property, format_descriptionProperty)) {
            value = this.bitstream.getFormatDescription();
        } else if (this.elementsEqualIsh(property, checksumProperty)) {
            value = this.bitstream.getChecksum();
        } else if (this.elementsEqualIsh(property, checksum_algorithmProperty)) {
            value = this.bitstream.getChecksumAlgorithm();
        } else if (this.elementsEqualIsh(property, sequence_idProperty)) {
            int sid = this.bitstream.getSequenceID();
            if (sid >= 0) {
                value = String.valueOf(sid);
            }
        } else if (this.elementsEqualIsh(property, bundleProperty)) {
            Bundle[] bn = this.bitstream.getBundles();
            if (bn != null && bn.length > 0) {
                value = bn[0].getName();
            }
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVBitstream.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String newValue;
        Namespace ns = prop.getNamespace();
        String propName = prop.getName();
        boolean nsDspace = ns != null && ns.equals((Object)DAV.NS_DSPACE);
        String string = newValue = action == 2 ? null : prop.getText();
        if (this.elementsEqualIsh(prop, displaynameProperty)) {
            this.bitstream.setName(newValue);
        } else if (nsDspace && propName.equals("description")) {
            this.bitstream.setDescription(newValue);
        } else if (nsDspace && propName.equals("source")) {
            this.bitstream.setSource(newValue);
        } else if (nsDspace && propName.equals("format_description")) {
            this.bitstream.setUserFormatDescription(newValue);
        } else if (nsDspace && propName.equals("format")) {
            if (action == 2) {
                throw new DAVStatusException(409, "The format property cannot be removed.");
            }
            BitstreamFormat bsf = BitstreamFormat.findByShortDescription((Context)this.context, (String)newValue);
            if (bsf == null) {
                throw new DAVStatusException(409, "Cannot set format, no such Bitstream Format: " + newValue);
            }
            this.bitstream.setFormat(bsf);
        } else {
            throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
        }
        this.bitstream.update();
        return 200;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        if (this.bitstream == null) {
            throw new DAVStatusException(404, "Bitstream not found, URI=\"" + this.hrefURL() + "\"");
        }
        if (this.item != null) {
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"DAV GET Bitstream", (String)("item handle=" + this.item.getHandle() + ", bitstream_id=" + this.bitstream.getID())));
        }
        this.response.setContentType(this.bitstream.getFormat().getMIMEType());
        this.response.setHeader("Content-Length", String.valueOf(this.bitstream.getSize()));
        InputStream is = this.bitstream.retrieve();
        Utils.bufferedCopy((InputStream)is, (OutputStream)this.response.getOutputStream());
        is.close();
        this.response.getOutputStream().flush();
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT is not implemented for Bitstream (yet?).");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented.");
    }

    private String makeDisplayname() {
        String[] ext = this.bitstream.getFormat().getExtensions();
        String prefix = this.item == null ? "retrieve_" + String.valueOf(this.bitstream.getID()) : "bitstream_" + String.valueOf(this.bitstream.getSequenceID());
        return prefix + (ext.length > 0 ? ext[0] : "");
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        if (pathElt[0].startsWith("retrieve_")) {
            Bitstream bs = DAVBitstream.findBitstream(context, null, pathElt[0]);
            return new DAVBitstream(context, request, response, pathElt, bs);
        }
        return null;
    }

    protected static Element makeXmlBitstream(Bitstream bitstream, DAVResource resource) throws AuthorizeException, SQLException, IOException {
        Element b = new Element("bitstream", DAV.NS_DSPACE);
        long length = bitstream.getSize();
        BitstreamFormat bf = bitstream.getFormat();
        if (length > 2000L) {
            Element e = new Element("link", DAV.NS_DSPACE);
            e.setAttribute("href", resource.hrefPrefix() + "retrieve_" + String.valueOf(bitstream.getID()));
            b.addContent((Content)e);
        } else {
            Element e = new Element("content", DAV.NS_DSPACE);
            if (bf != null) {
                e.setAttribute("contenttype", bf.getMIMEType());
            }
            e.setAttribute("contentlength", String.valueOf(length));
            e.setAttribute("contentencoding", "base64");
            b.addContent((Content)e);
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)length);
            Utils.copy((InputStream)bitstream.retrieve(), (OutputStream)baos);
            e.setText(new String(Base64.encodeBase64((byte[])baos.toByteArray())));
        }
        return b;
    }

    protected static InputStream getXmlBitstreamContent(Context context, Element xb) {
        String enc;
        Element c = xb.getChild("content", DAV.NS_DSPACE);
        if (c != null && (enc = c.getAttributeValue("contentencoding")) != null && enc.equals("base64")) {
            byte[] value = Base64.decodeBase64((byte[])c.getText().getBytes());
            return new ByteArrayInputStream(value);
        }
        return null;
    }

    protected static BitstreamFormat getXmlBitstreamFormat(Context context, Element xb) throws SQLException {
        String ctype;
        Element c = xb.getChild("content", DAV.NS_DSPACE);
        if (c != null && (ctype = c.getAttributeValue("contenttype")) != null) {
            BitstreamFormat[] af;
            for (BitstreamFormat element : af = BitstreamFormat.findAll((Context)context)) {
                if (!ctype.equals(element.getMIMEType())) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for BitStream.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for BitStream.");
    }

    static {
        allProps.add(getcontentlengthProperty);
        allProps.add(getcontenttypeProperty);
        allProps.add(sourceProperty);
        allProps.add(descriptionProperty);
        allProps.add(formatProperty);
        allProps.add(format_descriptionProperty);
        allProps.add(checksumProperty);
        allProps.add(checksum_algorithmProperty);
        allProps.add(sequence_idProperty);
        allProps.add(bundleProperty);
        allProps.add(handleProperty);
    }
}

