/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.app.dav.DAVWorkflow;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowItem;
import org.jdom.Content;
import org.jdom.Element;

class DAVCollection
extends DAVDSpaceObject {
    private static Logger log = Logger.getLogger(DAVCollection.class);
    private Collection collection = null;
    private static String tempDirectory = ConfigurationManager.getProperty((String)"upload.temp.dir");
    private static final Element short_descriptionProperty = new Element("short_description", DAV.NS_DSPACE);
    private static final Element introductory_textProperty = new Element("introductory_text", DAV.NS_DSPACE);
    private static final Element side_bar_textProperty = new Element("side_bar_text", DAV.NS_DSPACE);
    private static final Element copyright_textProperty = new Element("copyright_text", DAV.NS_DSPACE);
    private static final Element provenance_descriptionProperty = new Element("provenance_description", DAV.NS_DSPACE);
    private static final Element default_licenseProperty = new Element("default_license", DAV.NS_DSPACE);
    private static final Element logoProperty = new Element("logo", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    protected DAVCollection(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, Collection collection) {
        super(context, request, response, pathElt, (DSpaceObject)collection);
        this.collection = collection;
        this.type = 4;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DAVResource[] children() throws SQLException {
        Vector<DAVItem> result = new Vector<DAVItem>();
        ItemIterator ii = this.collection.getItems();
        try {
            while (ii.hasNext()) {
                Item item = ii.next();
                result.add(new DAVItem(this.context, this.request, this.response, this.makeChildPath((DSpaceObject)item), item));
            }
        }
        finally {
            if (ii != null) {
                ii.close();
            }
        }
        return result.toArray(new DAVResource[result.size()]);
    }

    protected Collection getCollection() {
        return this.collection;
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = this.getObjectMetadata("name");
            if (value == null) {
                value = this.collection.getHandle();
            }
        } else if (this.elementsEqualIsh(property, handleProperty)) {
            value = DAVCollection.canonicalizeHandle(this.collection.getHandle());
        } else if (this.elementsEqualIsh(property, logoProperty)) {
            Element le;
            Bitstream lbs = this.collection.getLogo();
            if (lbs != null && (le = DAVBitstream.makeXmlBitstream(lbs, this)) != null) {
                Element p = new Element("logo", DAV.NS_DSPACE);
                p.addContent((Content)le);
                return p;
            }
        } else if (this.elementsEqualIsh(property, short_descriptionProperty)) {
            value = this.getObjectMetadata("short_description");
        } else if (this.elementsEqualIsh(property, introductory_textProperty)) {
            value = this.getObjectMetadata("introductory_text");
        } else if (this.elementsEqualIsh(property, side_bar_textProperty)) {
            value = this.getObjectMetadata("side_bar_text");
        } else if (this.elementsEqualIsh(property, copyright_textProperty)) {
            value = this.getObjectMetadata("copyright_text");
        } else if (this.elementsEqualIsh(property, default_licenseProperty)) {
            value = this.collection.hasCustomLicense() ? this.collection.getLicense() : null;
        } else if (this.elementsEqualIsh(property, provenance_descriptionProperty)) {
            value = this.getObjectMetadata("provenance_description");
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVCollection.filterForXML(value));
        return p;
    }

    private String getObjectMetadata(String mdname) {
        try {
            return this.collection.getMetadata(mdname);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String newValue;
        String string = newValue = action == 2 ? null : prop.getText();
        if (this.elementsEqualIsh(prop, short_descriptionProperty) || this.elementsEqualIsh(prop, introductory_textProperty) || this.elementsEqualIsh(prop, side_bar_textProperty) || this.elementsEqualIsh(prop, copyright_textProperty) || this.elementsEqualIsh(prop, provenance_descriptionProperty)) {
            this.collection.setMetadata(prop.getName(), newValue);
        } else if (this.elementsEqualIsh(prop, displaynameProperty)) {
            this.collection.setMetadata("name", newValue);
        } else if (this.elementsEqualIsh(prop, default_licenseProperty)) {
            this.collection.setLicense(newValue);
        } else {
            if (!this.elementsEqualIsh(prop, logoProperty)) throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
            if (action == 2) {
                this.collection.setLogo(null);
            } else {
                Element bs = prop.getChild("bitstream", DAV.NS_DSPACE);
                if (bs == null) throw new DAVStatusException(409, "No <bitstream> element value found for logo property.");
                InputStream bis = DAVBitstream.getXmlBitstreamContent(this.context, bs);
                BitstreamFormat bsf = DAVBitstream.getXmlBitstreamFormat(this.context, bs);
                if (bis == null || bsf == null) {
                    throw new DAVStatusException(409, "Unacceptable value for logo property.");
                }
                Bitstream nbs = this.collection.setLogo(bis);
                nbs.setFormat(bsf);
                nbs.update();
            }
        }
        this.collection.update();
        return 200;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET not implemented for Collection.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        try {
            String packageType = this.request.getParameter("package");
            if (packageType == null) {
                packageType = this.request.getContentType();
            }
            if (packageType == null) {
                throw new DAVStatusException(400, "Cannot determine package type,  need content-type header or package param");
            }
            PackageIngester sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)packageType);
            if (sip == null) {
                throw new DAVStatusException(400, "Cannot find importer for package type: " + packageType);
            }
            int contentLength = this.request.getIntHeader("Content-Length");
            Object pis = this.request.getInputStream();
            if (contentLength >= 0) {
                pis = new CountedInputStream((InputStream)pis, contentLength);
                log.debug((Object)("put: Using CountedInputStream, length=" + String.valueOf(contentLength)));
            }
            File tempDir = new File(tempDirectory);
            File tempFile = File.createTempFile("davUpload" + pis.hashCode(), null, tempDir);
            log.debug((Object)("Storing temporary file at " + tempFile.getCanonicalPath()));
            FileOutputStream fos = new FileOutputStream(tempFile);
            Utils.copy((InputStream)pis, (OutputStream)fos);
            fos.close();
            ((InputStream)pis).close();
            PackageParameters params = PackageParameters.create((ServletRequest)this.request);
            params.setWorkflowEnabled(true);
            DSpaceObject ingestedDso = sip.ingest(this.context, (DSpaceObject)this.collection, tempFile, params, null);
            Item item = (Item)ingestedDso;
            tempFile.deleteOnExit();
            WorkflowItem wfi = WorkflowItem.findByItem((Context)this.context, (Item)item);
            int state = wfi != null ? wfi.getState() : 7;
            String location = null;
            if (state == 7) {
                String handle = HandleManager.findHandle((Context)this.context, (DSpaceObject)item);
                String end = handle != null ? DAVDSpaceObject.getPathElt(handle) : DAVItem.getPathElt(item);
                DAVItem newItem = new DAVItem(this.context, this.request, this.response, this.makeChildPath(end), item);
                location = newItem.hrefURL();
            } else if (state == 0 || state == 1) {
                location = this.hrefPrefix() + DAVWorkflow.getPath(wfi);
            } else {
                throw new DAVStatusException(500, "Workflow object in unexpected state, state=" + String.valueOf(state) + ", aborting PUT.");
            }
            this.context.commit();
            log.info((Object)("Created new Item, location=" + location));
            this.response.setHeader("Location", location);
            this.response.setStatus(201);
        }
        catch (PackageException pe) {
            pe.log(log);
            throw new DAVStatusException(500, pe.toString(), pe);
        }
        catch (CrosswalkException ie) {
            String reason = "";
            if (ie.getCause() != null) {
                reason = ", Reason: " + ie.getCause().toString();
            }
            log.error((Object)(ie.toString() + reason));
            throw new DAVStatusException(500, ie.toString() + reason, ie);
        }
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for Collection.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        Community[] ca = this.collection.getCommunities();
        if (ca != null) {
            for (Community element : ca) {
                element.removeCollection(this.collection);
            }
        }
        return 200;
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Collection.");
    }

    static {
        allProps.add(logoProperty);
        allProps.add(short_descriptionProperty);
        allProps.add(introductory_textProperty);
        allProps.add(side_bar_textProperty);
        allProps.add(copyright_textProperty);
        allProps.add(default_licenseProperty);
        allProps.add(provenance_descriptionProperty);
        allProps.add(handleProperty);
    }

    private static class CountedInputStream
    extends FilterInputStream {
        private long count = 0L;
        private long length = -1L;

        protected CountedInputStream(InputStream is, long length) {
            super(is);
            this.length = length;
        }

        @Override
        public int read() throws IOException {
            if (++this.count > this.length) {
                return -1;
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.count >= this.length) {
                return -1;
            }
            int result = super.read(b);
            if (this.count > 0L) {
                this.count += (long)result;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.count >= this.length) {
                return -1;
            }
            int result = super.read(b, off, len);
            if (this.count > 0L) {
                this.count += (long)result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = super.skip(n);
            this.count += result;
            return result;
        }
    }
}

