/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVCollection;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.jdom.Content;
import org.jdom.Element;

class DAVCommunity
extends DAVDSpaceObject {
    private Community community = null;
    private static final Element short_descriptionProperty = new Element("short_description", DAV.NS_DSPACE);
    private static final Element introductory_textProperty = new Element("introductory_text", DAV.NS_DSPACE);
    private static final Element side_bar_textProperty = new Element("side_bar_text", DAV.NS_DSPACE);
    private static final Element copyright_textProperty = new Element("copyright_text", DAV.NS_DSPACE);
    private static final Element logoProperty = new Element("logo", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    protected DAVCommunity(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, Community community) {
        super(context, request, response, pathElt, (DSpaceObject)community);
        this.community = community;
        this.type = 8;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        Collection[] colls;
        Community[] subs;
        Vector<DAVDSpaceObject> result = new Vector<DAVDSpaceObject>();
        for (Community element : subs = this.community.getSubcommunities()) {
            result.add(new DAVCommunity(this.context, this.request, this.response, this.makeChildPath((DSpaceObject)element), element));
        }
        for (Collection element : colls = this.community.getCollections()) {
            result.add(new DAVCollection(this.context, this.request, this.response, this.makeChildPath((DSpaceObject)element), element));
        }
        return result.toArray(new DAVResource[result.size()]);
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = this.getObjectMetadata("name");
            if (value == null) {
                value = this.community.getHandle();
            }
        } else if (this.elementsEqualIsh(property, logoProperty)) {
            Element le;
            Bitstream lbs = this.community.getLogo();
            if (lbs != null && (le = DAVBitstream.makeXmlBitstream(lbs, this)) != null) {
                Element p = new Element("logo", DAV.NS_DSPACE);
                p.addContent((Content)le);
                return p;
            }
        } else if (this.elementsEqualIsh(property, handleProperty)) {
            value = DAVCommunity.canonicalizeHandle(this.community.getHandle());
        } else if (this.elementsEqualIsh(property, short_descriptionProperty)) {
            value = this.getObjectMetadata("short_description");
        } else if (this.elementsEqualIsh(property, introductory_textProperty)) {
            value = this.getObjectMetadata("introductory_text");
        } else if (this.elementsEqualIsh(property, side_bar_textProperty)) {
            value = this.getObjectMetadata("side_bar_text");
        } else if (this.elementsEqualIsh(property, copyright_textProperty)) {
            value = this.getObjectMetadata("copyright_text");
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVCommunity.filterForXML(value));
        return p;
    }

    private String getObjectMetadata(String mdname) {
        try {
            return this.community.getMetadata(mdname);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String newValue;
        String string = newValue = action == 2 ? null : prop.getText();
        if (this.elementsEqualIsh(prop, short_descriptionProperty) || this.elementsEqualIsh(prop, introductory_textProperty) || this.elementsEqualIsh(prop, side_bar_textProperty) || this.elementsEqualIsh(prop, copyright_textProperty)) {
            this.community.setMetadata(prop.getName(), newValue);
        } else if (this.elementsEqualIsh(prop, displaynameProperty)) {
            this.community.setMetadata("name", newValue);
        } else {
            if (!this.elementsEqualIsh(prop, logoProperty)) throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
            if (action == 2) {
                this.community.setLogo(null);
            } else {
                Element bs = prop.getChild("bitstream", DAV.NS_DSPACE);
                if (bs == null) throw new DAVStatusException(409, "No <bitstream> element value found for logo property.");
                InputStream bis = DAVBitstream.getXmlBitstreamContent(this.context, bs);
                BitstreamFormat bsf = DAVBitstream.getXmlBitstreamFormat(this.context, bs);
                if (bis == null || bsf == null) {
                    throw new DAVStatusException(409, "Unacceptable value for logo property.");
                }
                Bitstream nbs = this.community.setLogo(bis);
                nbs.setFormat(bsf);
                nbs.update();
            }
        }
        this.community.update();
        return 200;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for Community.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for Community.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for Community.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        Community c = this.community.getParentCommunity();
        if (c != null) {
            c.removeSubcommunity(this.community);
        }
        this.community.delete();
        return 200;
    }

    @Override
    protected int mkcolInternal(String name) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        Collection newColl = this.community.createCollection();
        newColl.setMetadata("name", name);
        newColl.update();
        return 200;
    }

    static {
        allProps.add(logoProperty);
        allProps.add(short_descriptionProperty);
        allProps.add(introductory_textProperty);
        allProps.add(side_bar_textProperty);
        allProps.add(copyright_textProperty);
        allProps.add(handleProperty);
    }
}

