/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVCollection;
import org.dspace.app.dav.DAVCommunity;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.jdom.Element;

abstract class DAVDSpaceObject
extends DAVResource {
    protected DSpaceObject dso = null;
    protected static final Element handleProperty = new Element("handle", DAV.NS_DSPACE);
    private static final char handleSeparator = '$';

    protected DAVDSpaceObject(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, DSpaceObject dso) {
        super(context, request, response, pathElt);
        this.dso = dso;
    }

    protected static String getPathElt(DSpaceObject dso) {
        String handle = dso.getHandle();
        if (handle == null) {
            return null;
        }
        return DAVDSpaceObject.getPathElt(handle);
    }

    protected static String getPathElt(String handle) {
        handle = handle.replaceFirst("/", String.valueOf('$'));
        return "dso_" + DAVDSpaceObject.encodeHandle(handle);
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException, AuthorizeException {
        if (pathElt[0].startsWith("dso_")) {
            DSpaceObject dso;
            String handle;
            int sepIndex;
            int i;
            for (i = 1; i < pathElt.length && pathElt[i].startsWith("dso_"); ++i) {
            }
            if ((sepIndex = (handle = DAVDSpaceObject.decodeHandle(pathElt[--i].substring(4))).indexOf(36)) >= 0) {
                char[] hc = handle.toCharArray();
                hc[sepIndex] = 47;
                handle = String.copyValueOf(hc);
            }
            if ((dso = HandleManager.resolveToObject((Context)context, (String)handle)) == null) {
                throw new DAVStatusException(404, "Cannot resolve handle \"" + handle + "\"");
            }
            if (dso.getType() == 2) {
                if (i + 1 < pathElt.length) {
                    if (pathElt[i + 1].startsWith("bitstream_")) {
                        Bitstream bs = DAVBitstream.findBitstream(context, (Item)dso, pathElt[i + 1]);
                        if (bs == null) {
                            throw new DAVStatusException(404, "Bitstream \"" + pathElt[i + 1] + "\" not found in item: " + pathElt[i]);
                        }
                        return new DAVBitstream(context, request, response, pathElt, (Item)dso, bs);
                    }
                    throw new DAVStatusException(404, "Illegal resource path, \"" + pathElt[i + 1] + "\" is not a Bitstream identifier for item: " + pathElt[i]);
                }
                return new DAVItem(context, request, response, pathElt, (Item)dso);
            }
            if (dso.getType() == 3) {
                return new DAVCollection(context, request, response, pathElt, (Collection)dso);
            }
            if (dso.getType() == 4) {
                return new DAVCommunity(context, request, response, pathElt, (Community)dso);
            }
            throw new DAVStatusException(400, "Unrecognized DSpace object type for handle=" + handle);
        }
        return null;
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (!this.elementsEqualIsh(property, handleProperty)) {
            if (this.elementsEqualIsh(property, current_user_privilege_setProperty)) {
                Element c = (Element)current_user_privilege_setProperty.clone();
                if (AuthorizeManager.isAdmin((Context)this.context)) {
                    DAVDSpaceObject.addPrivilege(c, new Element("all", DAV.NS_DAV));
                } else {
                    for (int i = 0; i < Constants.actionText.length; ++i) {
                        Element priv;
                        if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)this.dso, (int)i) || (priv = DAVDSpaceObject.actionToPrivilege(i)) == null) continue;
                        DAVDSpaceObject.addPrivilege(c, priv);
                    }
                }
                return c;
            }
            return this.commonPropfindInternal(property, this.dso.getType() != 0);
        }
        value = DAVDSpaceObject.canonicalizeHandle(this.dso.getHandle());
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVDSpaceObject.filterForXML(value));
        return p;
    }

    @Override
    protected Element typeValue() {
        return new Element(Constants.typeText[this.dso.getType()].toLowerCase(), DAV.NS_DSPACE);
    }
}

