/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVEPersonEPerson;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Element;

class DAVEPerson
extends DAVResource {
    private static Logger log = Logger.getLogger(DAVEPerson.class);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    @Override
    protected Element typeValue() {
        return new Element("eperson-collection", DAV.NS_DSPACE);
    }

    protected DAVEPerson(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        super(context, request, response, pathElt);
        this.type = 32;
    }

    protected static String getPath(EPerson ep) {
        return "eperson/" + DAVEPersonEPerson.getPathElt(ep);
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException, AuthorizeException {
        if (pathElt.length > 0 && pathElt[0].equals("eperson")) {
            if (pathElt.length > 1) {
                return DAVEPersonEPerson.matchResourceURI(context, request, response, pathElt);
            }
            return new DAVEPerson(context, request, response, pathElt);
        }
        return null;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        if (AuthorizeManager.isAdmin((Context)this.context)) {
            EPerson[] all = EPerson.findAll((Context)this.context, (int)3);
            DAVResource[] result = new DAVResource[all.length];
            log.debug((Object)("EPerson children(), got " + String.valueOf(all.length) + " e-people."));
            for (int i = 0; i < all.length; ++i) {
                result[i] = new DAVEPersonEPerson(this.context, this.request, this.response, this.makeChildPath(DAVEPersonEPerson.getPathElt(all[i].getID())), all[i]);
            }
            return result;
        }
        EPerson self = this.context.getCurrentUser();
        if (self == null) {
            return new DAVResource[0];
        }
        DAVResource[] result = new DAVResource[]{new DAVEPersonEPerson(this.context, this.request, this.response, this.makeChildPath(DAVEPersonEPerson.getPathElt(self.getID())), self)};
        return result;
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (!this.elementsEqualIsh(property, displaynameProperty)) {
            return this.commonPropfindInternal(property, true);
        }
        value = this.pathElt[0];
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVEPerson.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for eperson.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for eperson.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for eperson.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for eperson.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for eperson.");
    }
}

