/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Element;

class DAVEPersonEPerson
extends DAVResource {
    private EPerson eperson = null;
    private static final Element emailProperty = new Element("email", DAV.NS_DSPACE);
    private static final Element first_nameProperty = new Element("first_name", DAV.NS_DSPACE);
    private static final Element last_nameProperty = new Element("last_name", DAV.NS_DSPACE);
    private static final Element handleProperty = new Element("handle", DAV.NS_DSPACE);
    private static final Element require_certificateProperty = new Element("require_certificate", DAV.NS_DSPACE);
    private static final Element self_registeredProperty = new Element("self_registered", DAV.NS_DSPACE);
    private static final Element can_loginProperty = new Element("can_login", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>();

    protected DAVEPersonEPerson(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, EPerson ep) {
        super(context, request, response, pathElt);
        this.type = 32;
        this.eperson = ep;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected Element typeValue() {
        return new Element("eperson", DAV.NS_DSPACE);
    }

    protected static String getPathElt(int dbid) {
        return "ep_db_" + String.valueOf(dbid);
    }

    protected static String getPathElt(EPerson ep) {
        return DAVEPersonEPerson.getPathElt(ep.getID());
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        return new DAVResource[0];
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException, AuthorizeException {
        try {
            if (pathElt[0].equals("eperson") && pathElt.length > 1) {
                EPerson ep = null;
                if (pathElt.length > 2) {
                    throw new DAVStatusException(404, "Invalid eperson resource path.");
                }
                if (pathElt[1].startsWith("ep_db_")) {
                    int id = Integer.parseInt(pathElt[1].substring(6));
                    ep = EPerson.find((Context)context, (int)id);
                } else {
                    ep = pathElt[1].equalsIgnoreCase("current") ? context.getCurrentUser() : EPerson.findByEmail((Context)context, (String)pathElt[1]);
                }
                if (ep == null) {
                    throw new DAVStatusException(404, "EPerson not found: " + pathElt[1]);
                }
                return new DAVEPersonEPerson(context, request, response, pathElt, ep);
            }
            return null;
        }
        catch (NumberFormatException ne) {
            throw new DAVStatusException(400, "Error parsing number in request URI.", ne);
        }
    }

    private boolean adminOrSelf(Context context) throws SQLException {
        if (AuthorizeManager.isAdmin((Context)context)) {
            return true;
        }
        EPerson self = context.getCurrentUser();
        return self != null && this.eperson != null && self.getID() == this.eperson.getID();
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = this.eperson.getFullName();
        } else if (this.elementsEqualIsh(property, emailProperty)) {
            value = this.eperson.getEmail();
        } else if (this.elementsEqualIsh(property, first_nameProperty)) {
            value = this.eperson.getFirstName();
        } else if (this.elementsEqualIsh(property, last_nameProperty)) {
            value = this.eperson.getLastName();
        } else if (this.elementsEqualIsh(property, handleProperty)) {
            value = DAVEPersonEPerson.canonicalizeHandle(this.eperson.getHandle());
            if (!this.adminOrSelf(this.context)) {
                throw new DAVStatusException(403, "Not authorized to read this property.");
            }
        } else if (this.elementsEqualIsh(property, require_certificateProperty)) {
            value = String.valueOf(this.eperson.getRequireCertificate());
            if (!this.adminOrSelf(this.context)) {
                throw new DAVStatusException(403, "Not authorized to read this property.");
            }
        } else if (this.elementsEqualIsh(property, self_registeredProperty)) {
            value = String.valueOf(this.eperson.getSelfRegistered());
            if (!this.adminOrSelf(this.context)) {
                throw new DAVStatusException(403, "Not authorized to read this property.");
            }
        } else if (this.elementsEqualIsh(property, can_loginProperty)) {
            value = String.valueOf(this.eperson.canLogIn());
            if (!this.adminOrSelf(this.context)) {
                throw new DAVStatusException(403, "Not authorized to read this property.");
            }
        } else {
            return this.commonPropfindInternal(property, false);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVEPersonEPerson.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        if (!this.adminOrSelf(this.context)) {
            throw new DAVStatusException(403, "No authorization to read this EPerson.");
        }
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for eperson.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for eperson.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for eperson.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for eperson.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for eperson.");
    }

    static {
        allProps.add(displaynameProperty);
        allProps.add(typeProperty);
        allProps.add(resourcetypeProperty);
        allProps.add(current_user_privilege_setProperty);
        allProps.add(emailProperty);
        allProps.add(first_nameProperty);
        allProps.add(last_nameProperty);
        allProps.add(handleProperty);
        allProps.add(require_certificateProperty);
        allProps.add(self_registeredProperty);
        allProps.add(can_loginProperty);
    }
}

