/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Element;

abstract class DAVInProgressSubmission
extends DAVResource {
    protected InProgressSubmission inProgressItem = null;
    protected static final Element collectionProperty = new Element("collection", DAV.NS_DSPACE);
    protected static final Element submitterProperty = new Element("submitter", DAV.NS_DSPACE);
    protected static final Element has_multiple_filesProperty = new Element("has_multiple_files", DAV.NS_DSPACE);
    protected static final Element has_multiple_titlesProperty = new Element("has_multiple_titles", DAV.NS_DSPACE);
    protected static final Element is_published_beforeProperty = new Element("is_published_before", DAV.NS_DSPACE);
    protected static final Element stateProperty = new Element("state", DAV.NS_DSPACE);
    protected static List<Element> inProgressProps = new ArrayList<Element>(9);

    protected DAVInProgressSubmission(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, InProgressSubmission wi) {
        super(context, request, response, pathElt);
        this.inProgressItem = wi;
        this.type = 32;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        DAVResource[] result = new DAVResource[1];
        Item item = this.inProgressItem.getItem();
        result[0] = new DAVItem(this.context, this.request, this.response, this.makeChildPath(DAVItem.getPathElt(item.getID())), item);
        return result;
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, collectionProperty)) {
            value = DAVInProgressSubmission.canonicalizeHandle(this.inProgressItem.getCollection().getHandle());
        } else if (this.elementsEqualIsh(property, submitterProperty)) {
            EPerson ep = this.inProgressItem.getSubmitter();
            if (ep != null) {
                value = this.hrefToEPerson(ep);
            }
        } else if (this.elementsEqualIsh(property, has_multiple_filesProperty)) {
            value = String.valueOf(this.inProgressItem.hasMultipleFiles());
        } else if (this.elementsEqualIsh(property, has_multiple_titlesProperty)) {
            value = String.valueOf(this.inProgressItem.hasMultipleTitles());
        } else if (this.elementsEqualIsh(property, is_published_beforeProperty)) {
            value = String.valueOf(this.inProgressItem.isPublishedBefore());
        } else {
            if (this.elementsEqualIsh(property, current_user_privilege_setProperty)) {
                Element c = (Element)current_user_privilege_setProperty.clone();
                DAVInProgressSubmission.addPrivilege(c, new Element("all", DAV.NS_DAV));
                return c;
            }
            return this.commonPropfindInternal(property, true);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVInProgressSubmission.filterForXML(value));
        return p;
    }

    static boolean parseBoolean(String in) throws DAVStatusException {
        if ((in = in.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (in.equalsIgnoreCase("false")) {
            return false;
        }
        throw new DAVStatusException(409, "Unacceptable value for boolean: " + in);
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String newValue;
        if (this.elementsEqualIsh(prop, displaynameProperty) || this.elementsEqualIsh(prop, resourcetypeProperty) || this.elementsEqualIsh(prop, typeProperty) || this.elementsEqualIsh(prop, collectionProperty) || this.elementsEqualIsh(prop, submitterProperty)) {
            throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
        }
        String string = newValue = action == 2 ? null : prop.getText();
        if (this.elementsEqualIsh(prop, has_multiple_filesProperty)) {
            this.inProgressItem.setMultipleFiles(DAVInProgressSubmission.parseBoolean(newValue));
        } else if (this.elementsEqualIsh(prop, has_multiple_titlesProperty)) {
            this.inProgressItem.setMultipleTitles(DAVInProgressSubmission.parseBoolean(newValue));
        } else if (this.elementsEqualIsh(prop, is_published_beforeProperty)) {
            this.inProgressItem.setPublishedBefore(DAVInProgressSubmission.parseBoolean(newValue));
        } else {
            return 404;
        }
        this.inProgressItem.update();
        return 200;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for workspace.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for workspace.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        return DAVItem.addItemToCollection(this.context, this.inProgressItem.getItem(), destination, overwrite);
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for InProgressSubmission.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for InProgressSubmission.");
    }

    static {
        inProgressProps.add(current_user_privilege_setProperty);
        inProgressProps.add(displaynameProperty);
        inProgressProps.add(resourcetypeProperty);
        inProgressProps.add(typeProperty);
        inProgressProps.add(collectionProperty);
        inProgressProps.add(submitterProperty);
        inProgressProps.add(has_multiple_filesProperty);
        inProgressProps.add(has_multiple_titlesProperty);
        inProgressProps.add(is_published_beforeProperty);
    }
}

