/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVCollection;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.license.CreativeCommons;
import org.jdom.Element;
import org.jdom.Namespace;

class DAVItem
extends DAVDSpaceObject {
    private static Logger log = Logger.getLogger(DAVItem.class);
    private Item item = null;
    private static final Element submitterProperty = new Element("submitter", DAV.NS_DSPACE);
    private static final Element getlastmodifiedProperty = new Element("getlastmodified", DAV.NS_DAV);
    private static final Element licenseProperty = new Element("license", DAV.NS_DSPACE);
    private static final Element cc_license_textProperty = new Element("cc_license_text", DAV.NS_DSPACE);
    private static final Element cc_license_rdfProperty = new Element("cc_license_rdf", DAV.NS_DSPACE);
    private static final Element cc_license_urlProperty = new Element("cc_license_url", DAV.NS_DSPACE);
    private static final Element owning_collectionProperty = new Element("owning_collection", DAV.NS_DSPACE);
    private static final Element withdrawnProperty = new Element("withdrawn", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    protected DAVItem(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, Item item) {
        super(context, request, response, pathElt, (DSpaceObject)item);
        this.type = 2;
        this.item = item;
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        int id = -1;
        String bsElt = null;
        try {
            if (pathElt[pathElt.length - 1].startsWith("item_db_")) {
                id = Integer.parseInt(pathElt[pathElt.length - 1].substring(8));
            } else if (pathElt[pathElt.length - 1].startsWith("bitstream_") && pathElt.length > 1 && pathElt[pathElt.length - 2].startsWith("item_db_")) {
                id = Integer.parseInt(pathElt[pathElt.length - 2].substring(8));
                bsElt = pathElt[pathElt.length - 1];
            }
            if (id >= 0) {
                Item item = Item.find((Context)context, (int)id);
                if (item == null) {
                    throw new DAVStatusException(404, "Item with ID=" + String.valueOf(id) + " not found.");
                }
                if (bsElt != null) {
                    Bitstream bs = DAVBitstream.findBitstream(context, item, bsElt);
                    if (bs == null) {
                        throw new DAVStatusException(404, "Bitstream not found.");
                    }
                    return new DAVBitstream(context, request, response, pathElt, item, bs);
                }
                return new DAVItem(context, request, response, pathElt, item);
            }
            return null;
        }
        catch (NumberFormatException ne) {
            throw new DAVStatusException(400, "Error parsing number in request URI.", ne);
        }
    }

    protected static String getPathElt(int dbid) {
        return "item_db_" + String.valueOf(dbid);
    }

    protected static String getPathElt(Item item) {
        String handle = item.getHandle();
        if (handle == null) {
            return DAVItem.getPathElt(item.getID());
        }
        return DAVDSpaceObject.getPathElt((DSpaceObject)item);
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        Bundle[] bundles;
        if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)this.item, (int)0)) {
            return new DAVResource[0];
        }
        Vector<DAVBitstream> result = new Vector<DAVBitstream>();
        for (Bundle element : bundles = this.item.getBundles()) {
            Bitstream[] bitstreams;
            if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)element, (int)0)) continue;
            for (Bitstream element0 : bitstreams = element.getBitstreams()) {
                String[] ext = element0.getFormat().getExtensions();
                result.add(new DAVBitstream(this.context, this.request, this.response, this.makeChildPath(DAVBitstream.getPathElt(element0.getSequenceID(), ext.length < 1 ? null : ext[0])), this.item, element0));
            }
        }
        return result.toArray(new DAVResource[result.size()]);
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (!this.elementsEqualIsh(property, withdrawnProperty)) {
            AuthorizeManager.authorizeAction((Context)this.context, (DSpaceObject)this.item, (int)0);
        }
        if (this.elementsEqualIsh(property, withdrawnProperty)) {
            value = String.valueOf(this.item.isWithdrawn());
        } else if (this.elementsEqualIsh(property, displaynameProperty)) {
            DCValue[] titleDc = this.item.getDC("title", "*", "*");
            value = titleDc.length > 0 ? titleDc[0].value : this.item.getHandle();
        } else if (this.elementsEqualIsh(property, handleProperty)) {
            value = DAVItem.canonicalizeHandle(this.item.getHandle());
        } else if (this.elementsEqualIsh(property, submitterProperty)) {
            EPerson ep = this.item.getSubmitter();
            if (ep != null) {
                value = this.hrefToEPerson(ep);
            }
        } else if (this.elementsEqualIsh(property, owning_collectionProperty)) {
            Collection owner = this.item.getOwningCollection();
            if (owner != null) {
                value = DAVItem.canonicalizeHandle(owner.getHandle());
            }
        } else if (this.elementsEqualIsh(property, getlastmodifiedProperty)) {
            value = DAV.applyHttpDateFormat(this.item.getLastModified());
        } else if (this.elementsEqualIsh(property, licenseProperty)) {
            value = this.getLicenseAsString();
        } else if (this.elementsEqualIsh(property, cc_license_textProperty)) {
            value = CreativeCommons.getLicenseText((Item)this.item);
        } else if (this.elementsEqualIsh(property, cc_license_rdfProperty)) {
            value = CreativeCommons.getLicenseRDF((Item)this.item);
        } else if (this.elementsEqualIsh(property, cc_license_urlProperty)) {
            value = CreativeCommons.getLicenseURL((Item)this.item);
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVItem.filterForXML(value));
        return p;
    }

    private String getLicenseAsString() throws SQLException, AuthorizeException, IOException {
        Bundle[] lb;
        for (Bundle element : lb = this.item.getBundles("LICENSE")) {
            Bitstream lbs = element.getBitstreamByName("license.txt");
            if (lbs == null) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)lbs.getSize());
            Utils.copy((InputStream)lbs.retrieve(), (OutputStream)baos);
            return baos.toString();
        }
        return null;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        Namespace ns = prop.getNamespace();
        String propName = prop.getName();
        if (ns != null && ns.equals((Object)DAV.NS_DSPACE) && propName.equals("submitter")) {
            if (action == 2) {
                throw new DAVStatusException(409, "The submitter property cannot be removed.");
            }
            String newName = prop.getText();
            EPerson ep = EPerson.findByEmail((Context)this.context, (String)newName);
            if (ep == null) {
                throw new DAVStatusException(409, "Cannot set submitter, no EPerson found for email address: " + newName);
            }
            this.item.setSubmitter(ep);
            this.item.update();
            return 200;
        }
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        PackageDisseminator dip;
        AuthorizeManager.authorizeAction((Context)this.context, (DSpaceObject)this.item, (int)0);
        String packageType = this.request.getParameter("package");
        if (packageType == null) {
            packageType = "default";
        }
        if ((dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, (String)packageType)) == null) {
            throw new DAVStatusException(400, "Cannot find a disseminate plugin for package=" + packageType);
        }
        try {
            String tempDirectory = ConfigurationManager.getProperty((String)"upload.temp.dir");
            File tempFile = File.createTempFile("DAVItemGet" + this.item.hashCode(), null, new File(tempDirectory));
            tempFile.deleteOnExit();
            PackageParameters pparams = PackageParameters.create((ServletRequest)this.request);
            this.response.setContentType(dip.getMIMEType(pparams));
            dip.disseminate(this.context, (DSpaceObject)this.item, pparams, tempFile);
            FileInputStream fileIn = null;
            try {
                fileIn = new FileInputStream(tempFile);
                Utils.copy((InputStream)fileIn, (OutputStream)this.response.getOutputStream());
            }
            finally {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
        }
        catch (CrosswalkException pe) {
            throw new DAVStatusException(500, "Failed in crosswalk of metadata: " + pe.toString(), pe);
        }
        catch (PackageException pe) {
            pe.log(log);
            throw new DAVStatusException(500, pe.toString(), pe);
        }
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT is not implemented for Item.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        return DAVItem.addItemToCollection(this.context, this.item, destination, overwrite);
    }

    protected static int addItemToCollection(Context context, Item item, DAVResource destination, boolean overwrite) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        Collection[] refs;
        if (!(destination instanceof DAVCollection)) {
            throw new DAVStatusException(405, "COPY of Item is only allowed when destination is a DSpace Collection.");
        }
        AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)0);
        Collection destColl = ((DAVCollection)destination).getCollection();
        log.debug((Object)("COPY from=" + item.toString() + " (" + item.getHandle() + "), to=" + destColl.toString() + " (" + destColl.getHandle() + ")"));
        for (Collection element : refs = item.getCollections()) {
            if (!destColl.equals((Object)element)) continue;
            log.debug((Object)("COPY - item @ " + item.getHandle() + " is already a member of collection @ " + destColl.getHandle()));
            if (overwrite) {
                return 204;
            }
            throw new DAVStatusException(409, "This Item is already a member of collection handle=" + destColl.getHandle());
        }
        destColl.addItem(item);
        return 204;
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        this.item.withdraw();
        return 200;
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Item.");
    }

    static {
        allProps.add(submitterProperty);
        allProps.add(getlastmodifiedProperty);
        allProps.add(licenseProperty);
        allProps.add(cc_license_textProperty);
        allProps.add(cc_license_rdfProperty);
        allProps.add(cc_license_urlProperty);
        allProps.add(owning_collectionProperty);
        allProps.add(handleProperty);
        allProps.add(withdrawnProperty);
    }
}

