/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.jdom.Element;

class DAVLookup
extends DAVResource {
    private static Logger log = Logger.getLogger(DAVLookup.class);
    private static final List<Element> allProps = new ArrayList<Element>();

    protected DAVLookup(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        super(context, request, response, pathElt);
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        if (pathElt[0].equals("lookup")) {
            return new DAVLookup(context, request, response, pathElt);
        }
        return null;
    }

    private void doRedirect() throws IOException, SQLException, DAVStatusException {
        DSpaceObject dso = null;
        String bsPid = null;
        int hdlStart = -1;
        if (this.pathElt.length > 2 && this.pathElt[1].equals("handle")) {
            hdlStart = 2;
        } else if (this.pathElt.length > 3 && this.pathElt[1].equals("bitstream-handle")) {
            bsPid = this.pathElt[2];
            hdlStart = 3;
        } else {
            throw new DAVStatusException(400, "Unrecognized 'lookup' request format.");
        }
        String prefix = DAVLookup.decodeHandle(this.pathElt[hdlStart]);
        String handle = null;
        if (prefix.indexOf(47) >= 0) {
            handle = prefix;
            log.debug((Object)("Lookup: resolving escaped handle \"" + handle + "\""));
        } else if (this.pathElt.length >= hdlStart + 2) {
            StringBuffer hdl = new StringBuffer(prefix);
            for (int i = hdlStart + 1; i < this.pathElt.length; ++i) {
                hdl.append("/");
                hdl.append(this.pathElt[i]);
            }
            handle = hdl.toString();
            log.debug((Object)("Lookup: resolving multielement handle \"" + handle + "\""));
        } else {
            throw new DAVStatusException(400, "Incomplete handle in lookup request.");
        }
        dso = HandleManager.resolveToObject((Context)this.context, (String)handle);
        if (dso == null) {
            throw new DAVStatusException(404, "Cannot resolve handle \"" + handle + "\"");
        }
        String location = this.makeLocation(dso, bsPid);
        if (location == null) {
            throw new DAVStatusException(404, "Bitstream \"" + bsPid + "\" does not exist in \"" + handle + "\"");
        }
        String qs = this.request.getQueryString();
        if (qs != null) {
            location = location + "?" + qs;
        }
        log.debug((Object)("Lookup returning redirect to: " + location));
        this.response.setHeader("Location", location);
        this.response.sendError(302, "These are not the droids you are looking for.");
    }

    protected String makeURI(String handle, String bsPid) throws IOException, SQLException {
        DSpaceObject dso = HandleManager.resolveToObject((Context)this.context, (String)handle);
        if (dso == null) {
            return null;
        }
        return this.makeURI(dso, bsPid);
    }

    private String makeURI(DSpaceObject dso, String bsPid) throws IOException, SQLException {
        if (bsPid != null) {
            if (dso.getType() != 2) {
                log.warn((Object)"Non-Item with Bitstream Sequence ID in DAV Lookup.");
                return null;
            }
            try {
                int pid = Integer.parseInt(bsPid);
                if (DAVBitstream.getBitstreamBySequenceID((Item)dso, pid) == null) {
                    log.warn((Object)("Bitstream Sequence ID Not Found in DAV Lookup: \"" + bsPid + "\""));
                    return null;
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("Invalid Bitstream Sequence ID in DAV Lookup: \"" + bsPid + "\""));
                return null;
            }
        }
        String base = "/" + DAVDSpaceObject.getPathElt(dso);
        if (bsPid != null) {
            return base + "/bitstream_" + bsPid;
        }
        return base;
    }

    private String makeLocation(DSpaceObject dso, String bsPid) throws IOException, SQLException {
        String prefix = this.hrefPrefix();
        String rest = this.makeURI(dso, bsPid);
        if (rest == null) {
            return null;
        }
        return prefix + rest.substring(1);
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        return null;
    }

    @Override
    protected void propfind() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.doRedirect();
    }

    @Override
    protected int proppatchInternal(int mode, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        return 405;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.doRedirect();
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.doRedirect();
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "COPY method not allowed on lookup resource.");
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        return new DAVResource[0];
    }

    @Override
    protected Element typeValue() {
        return null;
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for Lookup.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Lookup.");
    }
}

