/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVBitstream;
import org.dspace.app.dav.DAVDSpaceObject;
import org.dspace.app.dav.DAVEPerson;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVLookup;
import org.dspace.app.dav.DAVSite;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.app.dav.DAVWorkflow;
import org.dspace.app.dav.DAVWorkspace;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

abstract class DAVResource {
    private static Logger log = Logger.getLogger(DAVResource.class);
    protected String[] pathElt = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Context context = null;
    private static final String PROPFIND_LIMIT_CONFIG = "dav.propfind.limit";
    private static int propfindResourceLimit = ConfigurationManager.getIntProperty((String)"dav.propfind.limit");
    protected static final int TYPE_OTHER = 32;
    protected static final int TYPE_SITE = 16;
    protected static final int TYPE_COMMUNITY = 8;
    protected static final int TYPE_COLLECTION = 4;
    protected static final int TYPE_ITEM = 2;
    protected static final int TYPE_BITSTREAM = 1;
    protected static final int TYPE_ALL = 31;
    protected int type = 0;
    private static XMLOutputter outputRaw = new XMLOutputter();
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private static final boolean debugXML = ConfigurationManager.getBooleanProperty((String)"dav.debug.xml", (boolean)false);
    protected static final Element displaynameProperty = new Element("displayname", DAV.NS_DAV);
    protected static final Element resourcetypeProperty = new Element("resourcetype", DAV.NS_DAV);
    protected static final Element typeProperty = new Element("type", DAV.NS_DSPACE);
    protected static final Element current_user_privilege_setProperty = new Element("current-user-privilege-set", DAV.NS_DAV);
    protected static List<Element> commonProps = new ArrayList<Element>();

    protected DAVResource(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        this.pathElt = (String[])ArrayUtils.clone((Object[])pathElt);
        this.request = request;
        this.response = response;
        this.context = context;
    }

    protected abstract DAVResource[] children() throws SQLException;

    protected abstract Element propfindInternal(Element var1) throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected abstract List<Element> getAllProperties();

    protected abstract int proppatchInternal(int var1, Element var2) throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected abstract void get() throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected abstract void put() throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected abstract int copyInternal(DAVResource var1, int var2, boolean var3, boolean var4) throws DAVStatusException, SQLException, AuthorizeException, IOException;

    protected abstract Element typeValue();

    protected abstract int deleteInternal() throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected abstract int mkcolInternal(String var1) throws SQLException, AuthorizeException, IOException, DAVStatusException;

    protected DAVResource uriToResource(String uri) throws IOException, SQLException, DAVStatusException, AuthorizeException {
        String dest = uri;
        String prefix = this.hrefPrefix();
        if (dest.startsWith(prefix)) {
            dest = dest.substring(prefix.length());
        }
        if (dest.startsWith("/")) {
            dest = dest.substring(1);
        }
        return DAVResource.findResource(this.context, this.request, this.response, dest.split("/"));
    }

    protected static DAVResource findResource(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws IOException, SQLException, DAVStatusException, AuthorizeException {
        DAVResource result = DAVSite.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVLookup.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVWorkspace.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVWorkflow.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVEPerson.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVItem.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVBitstream.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        result = DAVDSpaceObject.matchResourceURI(context, request, response, pathElt);
        if (result != null) {
            return result;
        }
        throw new DAVStatusException(400, "Unrecognized DSpace resource URI");
    }

    protected String hrefPrefix() {
        if (this.request == null) {
            return "/";
        }
        return this.request.getScheme() + "://" + this.request.getServerName() + ":" + String.valueOf(this.request.getServerPort()) + this.request.getContextPath() + this.request.getServletPath() + "/";
    }

    protected String hrefURL() {
        StringBuffer result = new StringBuffer(this.hrefPrefix());
        for (int i = 0; i < this.pathElt.length; ++i) {
            if (i + 1 < this.pathElt.length) {
                result.append(this.pathElt[i]).append("/");
                continue;
            }
            result.append(this.pathElt[i]);
        }
        return result.toString();
    }

    protected String hrefToEPerson(EPerson ep) {
        return this.hrefPrefix() + DAVEPerson.getPath(ep);
    }

    protected String[] makeChildPath(DSpaceObject child) {
        String[] bpath = this.makeChildPathInternal();
        bpath[this.pathElt.length] = DAVDSpaceObject.getPathElt(child);
        return bpath;
    }

    protected String[] makeChildPath(String lastElt) {
        String[] bpath = this.makeChildPathInternal();
        bpath[this.pathElt.length] = lastElt;
        return bpath;
    }

    private String[] makeChildPathInternal() {
        String[] bpath = new String[this.pathElt.length + 1];
        for (int k = 0; k < this.pathElt.length; ++k) {
            bpath[k] = this.pathElt[k];
        }
        return bpath;
    }

    protected void propfind() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.request.setCharacterEncoding("UTF-8");
        int depth = 0;
        String sdepth = this.request.getHeader("Depth");
        if (sdepth != null) {
            sdepth = sdepth.trim();
            try {
                depth = sdepth.equalsIgnoreCase("infinity") ? -1 : Integer.parseInt(sdepth);
            }
            catch (NumberFormatException nfe) {
                throw new DAVStatusException(400, "Bad Depth header: " + sdepth, nfe);
            }
        }
        String[] types = this.request.getParameterValues("type");
        int typeMask = DAVResource.typesToMask(types);
        Document outdoc = this.propfindDriver(depth, (InputStream)this.request.getInputStream(), typeMask);
        if (outdoc != null) {
            this.response.setStatus(207);
            this.response.setContentType("text/xml");
            outputRaw.output(outdoc, (OutputStream)this.response.getOutputStream());
            if (debugXML) {
                log.debug((Object)("PROPFIND response = " + outputPretty.outputString(outdoc)));
            }
        }
    }

    protected Document propfindDriver(int depth, InputStream pfDoc, int typeMask) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        int pfType = 3;
        List pfProps = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document reqdoc = builder.build(pfDoc);
            Element propfind = reqdoc.getRootElement();
            if (!propfind.getName().equals("propfind") || !propfind.getNamespace().equals((Object)DAV.NS_DAV)) {
                throw new DAVStatusException(400, "Bad Root Element, must be propfind in DAV:");
            }
            List pfChild = propfind.getChildren();
            if (pfChild.size() > 0) {
                Element child0 = (Element)pfChild.get(0);
                String rawType = child0.getName();
                if (rawType.equalsIgnoreCase("prop")) {
                    pfType = 1;
                    pfProps = child0.getChildren();
                } else if (rawType.equalsIgnoreCase("allprop")) {
                    pfType = 3;
                } else if (rawType.equalsIgnoreCase("propname")) {
                    pfType = 2;
                } else {
                    log.warn((Object)LogManager.getHeader((Context)this.context, (String)"propfind", (String)("Unknown TYPE child of <propfind>, named: \"" + rawType + "\"")));
                }
            }
            if (debugXML) {
                log.debug((Object)("PROPFIND request = " + outputPretty.outputString(reqdoc)));
            }
        }
        catch (JDOMParseException je) {
            if (je.getLineNumber() >= 0) {
                log.error((Object)LogManager.getHeader((Context)this.context, (String)"propfind", (String)je.toString()));
                throw new DAVStatusException(400, "Could not parse request document: " + je.toString(), je);
            }
        }
        catch (JDOMException je) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"propfind", (String)je.toString()));
            throw new DAVStatusException(400, "Could not parse request document: " + je.toString(), je);
        }
        Element multistatus = new Element("multistatus", DAV.NS_DAV);
        Document outdoc = new Document(multistatus);
        this.propfindCrawler(multistatus, pfType, pfProps, depth, typeMask, 0);
        return outdoc;
    }

    private int propfindCrawler(Element multistatus, int pfType, List<Element> pfProps, int depth, int typeMask, int count) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        if ((this.type & typeMask) != 0 || this.type == 32) {
            if (propfindResourceLimit > 0 && ++count > propfindResourceLimit) {
                throw new DAVStatusException(409, "PROPFIND request exceeded server's limit on number of resources to query.");
            }
            String uri = this.hrefURL();
            log.debug((Object)("PROPFIND returning (count=" + String.valueOf(count) + ") href=" + uri));
            ArrayList<Element> notFound = new ArrayList<Element>();
            ArrayList<Element> forbidden = new ArrayList<Element>();
            Element responseElt = new Element("response", DAV.NS_DAV);
            multistatus.addContent((Content)responseElt);
            Element href = new Element("href", DAV.NS_DAV);
            href.setText(uri);
            responseElt.addContent((Content)href);
            if (pfType == 2) {
                responseElt.addContent((Content)DAVResource.makePropstat(DAVResource.copyElementList(this.getAllProperties()), 200, "OK"));
            } else {
                LinkedList<Element> success = new LinkedList<Element>();
                List<Element> props = pfType == 3 ? this.getAllProperties() : pfProps;
                ListIterator<Element> pi = props.listIterator();
                while (pi.hasNext()) {
                    Element property = pi.next();
                    try {
                        Element value = this.propfindInternal(property);
                        if (value != null) {
                            success.add(value);
                            continue;
                        }
                        notFound.add((Element)property.clone());
                    }
                    catch (DAVStatusException se) {
                        if (se.getStatus() == 404) {
                            notFound.add((Element)property.clone());
                            continue;
                        }
                        responseElt.addContent((Content)this.makePropstat((Element)property.clone(), se.getStatus(), se.getMessage()));
                    }
                    catch (AuthorizeException ae) {
                        forbidden.add((Element)property.clone());
                    }
                }
                if (success.size() > 0) {
                    responseElt.addContent((Content)DAVResource.makePropstat(success, 200, "OK"));
                }
                if (notFound.size() > 0) {
                    responseElt.addContent((Content)DAVResource.makePropstat(notFound, 404, "Not found"));
                }
                if (forbidden.size() > 0) {
                    responseElt.addContent((Content)DAVResource.makePropstat(forbidden, 403, "Not authorized."));
                }
            }
        }
        if (depth != 0 && (this.type - 1 & typeMask) != 0) {
            DAVResource[] kids;
            for (DAVResource element : kids = this.children()) {
                count = element.propfindCrawler(multistatus, pfType, pfProps, depth == -1 ? depth : depth - 1, typeMask, count);
            }
        }
        return count;
    }

    protected void proppatch() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.request.setCharacterEncoding("UTF-8");
        Document outdoc = this.proppatchDriver((InputStream)this.request.getInputStream());
        this.response.setStatus(207);
        this.response.setContentType("text/xml");
        outputRaw.output(outdoc, (OutputStream)this.response.getOutputStream());
        if (debugXML) {
            log.debug((Object)("PROPPATCH response = " + outputPretty.outputString(outdoc)));
        }
    }

    protected Document proppatchDriver(InputStream docStream) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        Document reqdoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            reqdoc = builder.build(docStream);
        }
        catch (JDOMParseException je) {
            if (je.getLineNumber() >= 0) {
                log.error((Object)LogManager.getHeader((Context)this.context, (String)"proppatch", (String)je.toString()));
                throw new DAVStatusException(400, "Could not parse PROPERTYUPDATE request document: " + je.toString(), je);
            }
        }
        catch (JDOMException je) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"proppatch", (String)je.toString()));
            throw new DAVStatusException(400, "Could not parse PROPERTYUPDATE request document: " + je.toString(), je);
        }
        if (reqdoc == null) {
            throw new DAVStatusException(400, "Failed to parse any valid PROPERTYUPDATE document in request.");
        }
        Element pupdate = reqdoc.getRootElement();
        if (!pupdate.getName().equals("propertyupdate") || !pupdate.getNamespace().equals((Object)DAV.NS_DAV)) {
            log.warn((Object)LogManager.getHeader((Context)this.context, (String)"proppatch", (String)("Got bad root element, XML=" + pupdate.toString())));
            throw new DAVStatusException(400, "Bad Root Element, must be propertyupdate in DAV:");
        }
        Element multistatus = new Element("multistatus", DAV.NS_DAV);
        Element msResponse = new Element("response", DAV.NS_DAV);
        multistatus.addContent((Content)msResponse);
        Element href = new Element("href", DAV.NS_DAV);
        msResponse.addContent((Content)href);
        href.addContent(this.hrefURL());
        boolean failing = false;
        LinkedList<Element> failedDep = new LinkedList<Element>();
        LinkedList<Element> success = new LinkedList<Element>();
        ListIterator ci = pupdate.getChildren().listIterator();
        while (ci.hasNext()) {
            int action = -1;
            Element e = (Element)ci.next();
            if (e.getName().equals("set") && e.getNamespace().equals((Object)DAV.NS_DAV)) {
                action = 1;
            } else if (e.getName().equals("remove") && e.getNamespace().equals((Object)DAV.NS_DAV)) {
                action = 2;
            } else {
                log.warn((Object)LogManager.getHeader((Context)this.context, (String)"proppatch", (String)("Got unrecognized PROPERTYUPDATE element:" + e.toString())));
                continue;
            }
            ListIterator pi = e.getChildren().listIterator();
            while (pi.hasNext()) {
                Element p = (Element)pi.next();
                if (p.getName().equals("prop") && p.getNamespace().equals((Object)DAV.NS_DAV)) {
                    ListIterator propi = p.getChildren().listIterator();
                    while (propi.hasNext()) {
                        Element thisprop = (Element)propi.next();
                        if (failing) {
                            failedDep.add(new Element(thisprop.getName(), thisprop.getNamespace()));
                            continue;
                        }
                        int status = 0;
                        String statusMsg = null;
                        try {
                            status = this.proppatchCommonInternal(action, thisprop);
                        }
                        catch (DAVStatusException se) {
                            status = se.getStatus();
                            statusMsg = se.getMessage();
                        }
                        catch (AuthorizeException ae) {
                            status = 403;
                            statusMsg = "Permission denied.";
                        }
                        if (status == 200) {
                            success.add(new Element(thisprop.getName(), thisprop.getNamespace()));
                            log.debug((Object)("proppatch SET/REMOVE OK, action=" + String.valueOf(action) + ", prop=" + thisprop.toString()));
                            continue;
                        }
                        failing = true;
                        msResponse.addContent((Content)this.makePropstat(thisprop, status, statusMsg));
                        log.debug((Object)("proppatch SET/REMOVE FAILED with status=" + String.valueOf(status) + ", on prop=" + thisprop.toString()));
                    }
                    continue;
                }
                log.warn((Object)LogManager.getHeader((Context)this.context, (String)"proppatch", (String)("No PROP element where expected, found:" + p.toString())));
            }
        }
        if (failing) {
            failedDep.addAll(success);
            if (failedDep.size() > 0) {
                msResponse.addContent((Content)DAVResource.makePropstat(failedDep, 424, "Failed because another property failed."));
            }
            this.context.abort();
        } else {
            if (success.size() > 0) {
                msResponse.addContent((Content)DAVResource.makePropstat(success, 200, "OK"));
            }
            this.context.complete();
        }
        return new Document(multistatus);
    }

    private int proppatchCommonInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        if (this.elementsEqualIsh(prop, resourcetypeProperty) || this.elementsEqualIsh(prop, typeProperty) || this.elementsEqualIsh(prop, current_user_privilege_setProperty)) {
            throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
        }
        return this.proppatchInternal(action, prop);
    }

    protected Element commonPropfindInternal(Element property, boolean isCollection) throws DAVStatusException, SQLException {
        if (this.elementsEqualIsh(property, typeProperty)) {
            Element p = (Element)typeProperty.clone();
            p.addContent((Content)this.typeValue());
            return p;
        }
        if (this.elementsEqualIsh(property, resourcetypeProperty)) {
            Element p = (Element)resourcetypeProperty.clone();
            if (isCollection) {
                p.addContent((Content)new Element("collection", DAV.NS_DAV));
            }
            return p;
        }
        if (this.elementsEqualIsh(property, current_user_privilege_setProperty)) {
            Element c = (Element)current_user_privilege_setProperty.clone();
            if (AuthorizeManager.isAdmin((Context)this.context)) {
                DAVResource.addPrivilege(c, new Element("all", DAV.NS_DAV));
            } else {
                DAVResource.addPrivilege(c, new Element("read", DAV.NS_DAV));
            }
            return c;
        }
        return null;
    }

    protected void copy() throws IOException, SQLException, AuthorizeException, DAVStatusException {
        int result;
        String destination = this.request.getHeader("Destination");
        if (destination == null) {
            throw new DAVStatusException(400, "Missing the required request header \"Destination\"");
        }
        try {
            String lastElt;
            String srcPath = new URI(this.request.getRequestURI()).getPath();
            String destPath = new URI(destination).getPath();
            int slash = srcPath.lastIndexOf(47);
            if (slash > -1 && destPath.endsWith(lastElt = srcPath.substring(slash))) {
                destination = destination.substring(0, destination.length() - lastElt.length() + 1);
            }
            log.debug((Object)("Copy dest. URI repair: srcPath=" + srcPath + ", destPath=" + destPath + ", final dest=" + destination));
        }
        catch (URISyntaxException e) {
            throw new DAVStatusException(400, "Illegal URI syntax in value of \"Destination\" header: " + destination, e);
        }
        int depth = -1;
        String sdepth = this.request.getHeader("Depth");
        if (sdepth != null) {
            sdepth = sdepth.trim();
            try {
                depth = sdepth.equalsIgnoreCase("infinity") ? -1 : Integer.parseInt(sdepth);
            }
            catch (NumberFormatException nfe) {
                throw new DAVStatusException(400, "Illegal value in Depth request header: " + sdepth, nfe);
            }
        }
        boolean overwrite = false;
        String soverwrite = this.request.getHeader("Overwrite");
        if (soverwrite != null && soverwrite.trim().equalsIgnoreCase("T")) {
            overwrite = true;
        }
        boolean keepProperties = false;
        Document reqdoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            reqdoc = builder.build((InputStream)this.request.getInputStream());
        }
        catch (JDOMParseException je) {
            if (je.getLineNumber() >= 0) {
                throw new DAVStatusException(400, "Error parsing XML document in COPY request.", je);
            }
        }
        catch (JDOMException je) {
            throw new DAVStatusException(400, "Error parsing XML document in COPY request: " + je.toString(), je);
        }
        if (reqdoc != null) {
            Element propertybehavior = reqdoc.getRootElement();
            Namespace ns = propertybehavior.getNamespace();
            if (ns == null || !ns.equals((Object)DAV.NS_DAV) || !propertybehavior.getName().equals("propertybehavior")) {
                throw new DAVStatusException(400, "Illegal XML document in COPY request, root= " + propertybehavior.toString());
            }
            if (propertybehavior.getChild("keepalive", DAV.NS_DAV) != null) {
                keepProperties = true;
            } else if (propertybehavior.getChild("omit", DAV.NS_DAV) == null) {
                throw new DAVStatusException(400, "Illegal propertybehavior document in COPY request, no omit or keepalive child.");
            }
        }
        if ((result = this.copyDriver(destination, depth, overwrite, keepProperties)) < 200 || result >= 300) {
            throw new DAVStatusException(result, "COPY Failed.");
        }
        this.response.setStatus(result);
    }

    protected int copyDriver(String destination, int depth, boolean overwrite, boolean keepProperties) throws IOException, SQLException, AuthorizeException, DAVStatusException {
        DAVResource destResource = this.uriToResource(destination);
        if (destResource == null) {
            throw new DAVStatusException(400, "Destination is not a legal DAV resource: " + destination);
        }
        log.debug((Object)("Executing COPY method, depth=" + String.valueOf(depth) + ", overwrite=" + String.valueOf(overwrite) + ", keepProperties=" + String.valueOf(keepProperties) + ", destination=\"" + destination + "\""));
        int result = this.copyInternal(destResource, depth, overwrite, keepProperties);
        this.context.commit();
        return result;
    }

    protected static int typesToMask(String[] types) throws DAVStatusException {
        int typeMask = 0;
        if (types == null || types.length == 0) {
            typeMask = 31;
        } else {
            for (String element : types) {
                String key = element.trim();
                if (key.equalsIgnoreCase("SITE")) {
                    typeMask |= 0x10;
                    continue;
                }
                if (key.equalsIgnoreCase("COMMUNITY")) {
                    typeMask |= 8;
                    continue;
                }
                if (key.equalsIgnoreCase("COLLECTION")) {
                    typeMask |= 4;
                    continue;
                }
                if (key.equalsIgnoreCase("ITEM")) {
                    typeMask |= 2;
                    continue;
                }
                if (key.equalsIgnoreCase("BITSTREAM")) {
                    typeMask |= 1;
                    continue;
                }
                throw new DAVStatusException(400, "Unrecognized type keyword: " + key);
            }
        }
        return typeMask;
    }

    protected boolean elementsEqualIsh(Element a, Element b) {
        Namespace nsa = a.getNamespace();
        Namespace nsb = b.getNamespace();
        return a.getName().equals(b.getName()) && (nsa == nsb || nsa != null && nsb != null && nsa.equals((Object)nsb));
    }

    private Element makePropstat(Element property, int status, String message) {
        Element ps = DAVResource.makePropstatInternal(status, message);
        Element p = new Element("prop", DAV.NS_DAV);
        Element pp = new Element(property.getName(), property.getNamespace());
        p.addContent((Content)pp);
        ps.addContent(0, (Content)p);
        return ps;
    }

    private static Element makePropstat(List<Element> properties, int status, String message) {
        Element ps = DAVResource.makePropstatInternal(status, message);
        Element p = new Element("prop", DAV.NS_DAV);
        p.addContent(properties);
        ps.addContent(0, (Content)p);
        return ps;
    }

    private static Element makePropstatInternal(int status, String message) {
        Element ps = new Element("propstat", DAV.NS_DAV);
        Element s = new Element("status", DAV.NS_DAV);
        s.addContent("HTTP/1.1 " + String.valueOf(status) + " " + message);
        ps.addContent((Content)s);
        return ps;
    }

    protected static Element actionToPrivilege(int action) {
        if (action == 3) {
            return new Element("bind", DAV.NS_DAV);
        }
        if (action == 11) {
            return new Element("collection_admin", DAV.NS_DSPACE);
        }
        if (action == 9) {
            return new Element("default_bitstream_read", DAV.NS_DSPACE);
        }
        if (action == 10) {
            return new Element("default_item_read", DAV.NS_DSPACE);
        }
        if (action == 2 || action == 4) {
            return new Element("unbind", DAV.NS_DAV);
        }
        if (action == 0) {
            return new Element("read", DAV.NS_DAV);
        }
        if (action == 8) {
            return new Element("workflow_abort", DAV.NS_DSPACE);
        }
        if (action == 5) {
            return new Element("workflow_step_1", DAV.NS_DSPACE);
        }
        if (action == 6) {
            return new Element("workflow_step_2", DAV.NS_DSPACE);
        }
        if (action == 7) {
            return new Element("workflow_step_3", DAV.NS_DSPACE);
        }
        if (action == 1) {
            return new Element("write", DAV.NS_DAV);
        }
        return null;
    }

    protected static void addPrivilege(Element prop, Element thePriv) {
        Element priv = new Element("privilege", DAV.NS_DAV);
        priv.addContent((Content)thePriv);
        prop.addContent((Content)priv);
    }

    private static List<Element> copyElementList(List<Element> el) {
        ArrayList<Element> result = new ArrayList<Element>(el.size());
        for (Element e : el) {
            result.add((Element)e.clone());
        }
        return result;
    }

    protected static String canonicalizeHandle(String handle) {
        if (handle != null) {
            if (handle.startsWith("hdl:")) {
                return handle;
            }
            return "hdl:" + handle;
        }
        return null;
    }

    protected static String filterForXML(String in) {
        Pattern illegals = Pattern.compile("[\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f]");
        Matcher m = illegals.matcher(in);
        if (m.find()) {
            return m.replaceAll("?");
        }
        return in;
    }

    protected static String decodeHandle(String pathFrag) {
        try {
            String handle = URLDecoder.decode(pathFrag, "UTF-8");
            if (pathFrag.indexOf("%25") >= 0) {
                handle = URLDecoder.decode(handle, "UTF-8");
            }
            return handle;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    protected static String encodeHandle(String handle) {
        try {
            return URLEncoder.encode(handle, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    protected void delete() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.request.setCharacterEncoding("UTF-8");
        Document outdoc = this.deleteDriver((InputStream)this.request.getInputStream());
        this.response.setStatus(207);
        this.response.setContentType("text/xml");
        outputRaw.output(outdoc, (OutputStream)this.response.getOutputStream());
        if (debugXML) {
            log.debug((Object)("DELETE response = " + outputPretty.outputString(outdoc)));
        }
    }

    protected Document deleteDriver(InputStream docStream) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        Document reqdoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            reqdoc = builder.build(docStream);
        }
        catch (JDOMParseException je) {
            if (je.getLineNumber() >= 0) {
                log.error((Object)LogManager.getHeader((Context)this.context, (String)"delete", (String)je.toString()));
                throw new DAVStatusException(400, "Could not parse DELETE request document: " + je.toString(), je);
            }
        }
        catch (JDOMException je) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"delete", (String)je.toString()));
            throw new DAVStatusException(400, "Could not parse DELETE request document: " + je.toString(), je);
        }
        if (reqdoc == null) {
            throw new DAVStatusException(400, "Failed to parse any valid DELETE document in request.");
        }
        Element pupdate = reqdoc.getRootElement();
        if (!pupdate.getName().equals("delete")) {
            log.warn((Object)LogManager.getHeader((Context)this.context, (String)"delete", (String)("Got bad root element, XML=" + pupdate.toString())));
            throw new DAVStatusException(400, "Bad Root Element, must be delete");
        }
        this.deleteInternal();
        Element multistatus = new Element("multistatus", DAV.NS_DAV);
        Element msResponse = new Element("response", DAV.NS_DAV);
        multistatus.addContent((Content)msResponse);
        Element href = new Element("href", DAV.NS_DAV);
        msResponse.addContent((Content)href);
        href.addContent(this.hrefURL());
        return new Document(multistatus);
    }

    protected void mkcol() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        this.request.setCharacterEncoding("UTF-8");
        Document outdoc = this.mkcolDriver((InputStream)this.request.getInputStream());
        this.response.setStatus(207);
        this.response.setContentType("text/xml");
        outputRaw.output(outdoc, (OutputStream)this.response.getOutputStream());
        if (debugXML) {
            log.debug((Object)("MKCOL response = " + outputPretty.outputString(outdoc)));
        }
    }

    protected Document mkcolDriver(InputStream docStream) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        Document reqdoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            reqdoc = builder.build(docStream);
        }
        catch (JDOMParseException je) {
            if (je.getLineNumber() >= 0) {
                log.error((Object)LogManager.getHeader((Context)this.context, (String)"mkcol", (String)je.toString()));
                throw new DAVStatusException(400, "Could not parse MKCOL request document: " + je.toString(), je);
            }
        }
        catch (JDOMException je) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"mkcol", (String)je.toString()));
            throw new DAVStatusException(400, "Could not parse MKCOL request document: " + je.toString(), je);
        }
        if (reqdoc == null) {
            throw new DAVStatusException(400, "Failed to parse any valid MKCOL document in request.");
        }
        Element pupdate = reqdoc.getRootElement();
        String newNodeName = pupdate.getValue();
        if (!"mkcol".equals(pupdate.getName()) || newNodeName == null) {
            log.warn((Object)LogManager.getHeader((Context)this.context, (String)"mkcol", (String)("Got bad root element, XML=" + pupdate.toString())));
            throw new DAVStatusException(400, "Bad Root Element, must be mkcol");
        }
        this.mkcolInternal(newNodeName);
        Element multistatus = new Element("multistatus", DAV.NS_DAV);
        Element msResponse = new Element("response", DAV.NS_DAV);
        multistatus.addContent((Content)msResponse);
        Element href = new Element("href", DAV.NS_DAV);
        msResponse.addContent((Content)href);
        href.addContent(this.hrefURL());
        return new Document(multistatus);
    }

    static {
        commonProps.add(displaynameProperty);
        commonProps.add(resourcetypeProperty);
        commonProps.add(typeProperty);
        commonProps.add(current_user_privilege_setProperty);
    }
}

