/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;

public class DAVServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(DAVServlet.class);
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static boolean allowAnonymousAccess = ConfigurationManager.getBooleanProperty((String)"dav.access.anonymous");
    private static final int HTTP_STATUS_MESSAGE_MAX = 1000;
    private static final String cookieSecret = Utils.generateHexKey();
    private static final String COOKIE_NAME = "DSpaceDavAuth";
    private static final long COOKIE_SELL_BY = 1800000L;

    private static Cookie gimmeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie element : cookies) {
                if (!element.getName().equals(COOKIE_NAME)) continue;
                return element;
            }
        }
        return null;
    }

    protected static boolean getAuthFromCookie(Context context, HttpServletRequest request) throws SQLException {
        Cookie cookie = DAVServlet.gimmeCookie(request);
        if (cookie == null) {
            return false;
        }
        String[] crumb = cookie.getValue().split("\\!");
        if (crumb.length != 4) {
            log.warn((Object)("Got invalid cookie value = \"" + cookie.getValue() + "\""));
            return false;
        }
        long timestamp = 0L;
        int epersonID = 0;
        try {
            timestamp = Long.parseLong(crumb[0]);
            epersonID = Integer.parseInt(crumb[1]);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Error groveling cookie, " + e.toString()));
            return false;
        }
        long now = new Date().getTime();
        if (timestamp > now || now - timestamp > 1800000L) {
            log.warn((Object)("Cookie is stale or has weird time, value = \"" + cookie.getValue() + "\""));
            return false;
        }
        if (!crumb[2].equals(request.getRemoteAddr())) {
            log.warn((Object)("Cookie fails IP Addr test, value = \"" + cookie.getValue() + "\""));
            return false;
        }
        String mac = Utils.getMD5((String)(crumb[0] + "!" + crumb[1] + "!" + crumb[2] + "!" + cookieSecret));
        if (!mac.equals(crumb[3])) {
            log.warn((Object)("Cookie fails MAC test, value = \"" + cookie.getValue() + "\""));
            return false;
        }
        EPerson cuser = EPerson.find((Context)context, (int)epersonID);
        if (cuser != null) {
            context.setCurrentUser(cuser);
            log.debug((Object)("Got authenticated user from cookie, id=" + crumb[1]));
            return true;
        }
        return false;
    }

    protected static void putAuthCookie(Context context, HttpServletRequest request, HttpServletResponse response, boolean force) {
        EPerson user;
        String[] crumb;
        Cookie cookie = DAVServlet.gimmeCookie(request);
        long now = new Date().getTime();
        if (!force && cookie != null && (crumb = cookie.getValue().split("\\!")).length == 4) {
            long timestamp = -1L;
            try {
                timestamp = Long.parseLong(crumb[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (timestamp > 0L && now - timestamp < 900000L) {
                return;
            }
        }
        if ((user = context.getCurrentUser()) == null) {
            return;
        }
        String value = String.valueOf(now) + "!" + String.valueOf(user.getID()) + "!" + request.getRemoteAddr() + "!";
        String mac = Utils.getMD5((String)(value + cookieSecret));
        cookie = new Cookie(COOKIE_NAME, value + mac);
        cookie.setPath(request.getContextPath());
        response.addCookie(cookie);
        log.debug((Object)("Setting new cookie, value = \"" + value + mac + "\""));
    }

    private static Context authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws IOException, SQLException {
        int[] groupIDs;
        Context context = new Context();
        if (DAVServlet.getAuthFromCookie(context, request)) {
            DAVServlet.putAuthCookie(context, request, response, false);
            return context;
        }
        String cred = request.getHeader("Authorization");
        if (cred != null && username == null && password == null) {
            String crud;
            String dcrud;
            int colon;
            log.info((Object)LogManager.getHeader((Context)context, (String)"got creds", (String)("Authorize: " + cred)));
            StringTokenizer ct = new StringTokenizer(cred);
            if (ct.nextToken().equalsIgnoreCase("Basic") && (colon = (dcrud = new String(Base64.decodeBase64((byte[])(crud = ct.nextToken()).getBytes()))).indexOf(58)) > 0) {
                username = DAVServlet.decodeFromURL(dcrud.substring(0, colon));
                password = DAVServlet.decodeFromURL(dcrud.substring(colon + 1));
                log.info((Object)LogManager.getHeader((Context)context, (String)"auth", (String)("Got username=\"" + username + "\" out of \"" + crud + "\".")));
            }
        }
        if (AuthenticationManager.authenticate((Context)context, (String)username, (String)password, null, (HttpServletRequest)request) == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"auth", (String)("Authentication returned SUCCESS, eperson=" + context.getCurrentUser().getEmail())));
        } else {
            if (username == null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"auth", (String)"No credentials, so sending WWW-Authenticate header."));
            } else {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"auth", (String)("Authentication FAILED, cred=" + cred)));
            }
            if (!allowAnonymousAccess) {
                if (response != null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"dspace\"");
                    response.sendError(401);
                }
                return null;
            }
        }
        for (int element : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(element);
            log.debug((Object)("Adding Special Group id=" + String.valueOf(element)));
        }
        DAVServlet.putAuthCookie(context, request, response, true);
        return context;
    }

    private static String getDavResourcePath(HttpServletRequest request) {
        String scriptName;
        String path = request.getRequestURI();
        String ppath = path.substring(request.getContextPath().length());
        if (ppath.startsWith(scriptName = request.getServletPath())) {
            ppath = ppath.substring(scriptName.length());
        }
        StringBuffer sb = new StringBuffer(ppath);
        int i = ppath.length() - 2;
        if (i > 0) {
            while ((i = ppath.lastIndexOf("//", i)) > -1) {
                sb.deleteCharAt(i + 1);
                --i;
            }
        }
        if (sb.length() > 0 && sb.charAt(0) == '/') {
            sb.deleteCharAt(0);
        }
        ppath = sb.toString();
        log.debug((Object)("Got DAV URI: PATH_INFO=\"" + ppath + "\""));
        return ppath;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(request, response);
        } else if (!DAVServlet.serviceInternal(method, request, response)) {
            super.service(request, response);
        }
    }

    private static String truncateForStatus(String msg) {
        return msg.length() > 1000 ? msg.substring(0, 1000) + "... [Message truncated, see logs for details.]" : msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean serviceInternal(String method, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (method.equals(METHOD_PUT) && request.getQueryString().indexOf("delete=true") >= 0) {
            method = METHOD_DELETE;
        }
        if (method.equals(METHOD_PUT) && request.getQueryString().indexOf("mkcol=true") >= 0) {
            method = METHOD_MKCOL;
        }
        if (!(method.equals(METHOD_PROPFIND) || method.equals(METHOD_PROPPATCH) || method.equals(METHOD_MKCOL) || method.equals(METHOD_COPY) || method.equals(METHOD_MOVE) || method.equals(METHOD_DELETE) || method.equals(METHOD_GET) || method.equals(METHOD_PUT))) {
            return false;
        }
        request.setCharacterEncoding("UTF-8");
        String[] pathElt = DAVServlet.getDavResourcePath(request).split("/");
        Context context = null;
        try {
            context = DAVServlet.authenticate(request, response, null, null);
            if (context == null) {
                boolean bl = true;
                return bl;
            }
            DAVResource resource = DAVResource.findResource(context, request, response, pathElt);
            if (resource != null) {
                if (method.equals(METHOD_PROPFIND)) {
                    resource.propfind();
                } else if (method.equals(METHOD_PROPPATCH)) {
                    resource.proppatch();
                } else if (method.equals(METHOD_COPY)) {
                    resource.copy();
                } else if (method.equals(METHOD_DELETE)) {
                    resource.delete();
                } else if (method.equals(METHOD_MKCOL)) {
                    resource.mkcol();
                } else if (method.equals(METHOD_GET)) {
                    resource.get();
                } else if (method.equals(METHOD_PUT)) {
                    resource.put();
                } else {
                    response.sendError(501);
                }
                context.complete();
                context = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.toString(), (Throwable)e);
            response.sendError(500, DAVServlet.truncateForStatus("Database access error: " + e.toString()));
        }
        catch (AuthorizeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.toString(), (Throwable)e);
            } else {
                log.info((Object)e.toString());
            }
            response.sendError(403, DAVServlet.truncateForStatus("Access denied: " + e.toString()));
        }
        catch (DAVStatusException e) {
            log.error((Object)e.toString(), (Throwable)e);
            response.sendError(e.getStatus(), DAVServlet.truncateForStatus(e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)e.toString(), (Throwable)e);
            response.sendError(500, DAVServlet.truncateForStatus("IO Error: " + e.toString()));
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            response.sendError(500, DAVServlet.truncateForStatus("IO Error: " + e.toString()));
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
        return true;
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader("DAV", "1");
        response.addHeader("Allow", "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, PROPFIND, PROPPATCH, MKCOL, COPY, MOVE");
    }

    protected static String decodeFromURL(String in) {
        try {
            return URLDecoder.decode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

