/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVCommunity;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.jdom.Element;

class DAVSite
extends DAVResource {
    private static final Element news_topProperty = new Element("news_top", DAV.NS_DSPACE);
    private static final Element news_sideProperty = new Element("news_side", DAV.NS_DSPACE);
    private static final Element default_licenseProperty = new Element("default_license", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    @Override
    protected Element typeValue() {
        return new Element("site", DAV.NS_DSPACE);
    }

    protected DAVSite(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        super(context, request, response, pathElt);
        this.type = 16;
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        if (pathElt.length == 0 || pathElt[0].length() == 0) {
            return new DAVSite(context, request, response, new String[0]);
        }
        return null;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        Community[] top = Community.findAllTop((Context)this.context);
        DAVResource[] result = new DAVResource[top.length];
        for (int i = 0; i < top.length; ++i) {
            result[i] = new DAVCommunity(this.context, this.request, this.response, this.makeChildPath((DSpaceObject)top[i]), top[i]);
        }
        return result;
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = ConfigurationManager.getProperty((String)"dspace.name");
        } else if (this.elementsEqualIsh(property, news_topProperty)) {
            value = ConfigurationManager.readNewsFile((String)"news-top.html");
        } else if (this.elementsEqualIsh(property, news_sideProperty)) {
            value = ConfigurationManager.readNewsFile((String)"news-side.html");
        } else if (this.elementsEqualIsh(property, default_licenseProperty)) {
            value = ConfigurationManager.getDefaultSubmissionLicense();
        } else {
            return this.commonPropfindInternal(property, true);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVSite.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String newValue;
        String string = newValue = action == 2 ? null : prop.getText();
        if (this.elementsEqualIsh(prop, news_topProperty)) {
            if (!AuthorizeManager.isAdmin((Context)this.context)) {
                throw new DAVStatusException(403, "Not authorized to modify this property.");
            }
            ConfigurationManager.writeNewsFile((String)"news-top.html", (String)newValue);
        } else if (this.elementsEqualIsh(prop, news_sideProperty)) {
            if (!AuthorizeManager.isAdmin((Context)this.context)) {
                throw new DAVStatusException(403, "Not authorized to modify this property.");
            }
            ConfigurationManager.writeNewsFile((String)"news-side.html", (String)newValue);
        } else {
            if (this.elementsEqualIsh(prop, displaynameProperty)) {
                throw new DAVStatusException(409, "The site name can only be changed through the DSpace Configuration, \"dspace.name\" property.");
            }
            throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
        }
        return 200;
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET is not implemented for Site.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT is not implemented for Site.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for Site.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Site.");
    }

    static {
        allProps.add(news_topProperty);
        allProps.add(news_sideProperty);
        allProps.add(default_licenseProperty);
    }
}

