/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.app.dav.DAVWorkflowItem;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.jdom.Element;

class DAVWorkflow
extends DAVResource {
    private static Logger log = Logger.getLogger(DAVWorkflow.class);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    @Override
    protected Element typeValue() {
        return new Element("workflow", DAV.NS_DSPACE);
    }

    protected DAVWorkflow(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        super(context, request, response, pathElt);
        this.type = 32;
    }

    protected static String getPath(WorkflowItem wfi) {
        return "workflow_pool/" + DAVWorkflowItem.getPathElt(wfi);
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        if (pathElt.length > 0 && pathElt[0].startsWith("workflow_")) {
            if (pathElt.length > 1) {
                return DAVWorkflowItem.matchResourceURI(context, request, response, pathElt);
            }
            if (pathElt[0].equals("workflow_own") || pathElt[0].equals("workflow_pool")) {
                return new DAVWorkflow(context, request, response, pathElt);
            }
            throw new DAVStatusException(404, "Unrecognized URI path element: " + pathElt[0]);
        }
        return null;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        EPerson ep = this.context.getCurrentUser();
        if (ep != null) {
            List wi = null;
            if (this.pathElt[0].equals("workflow_own")) {
                wi = WorkflowManager.getOwnedTasks((Context)this.context, (EPerson)ep);
            } else if (this.pathElt[0].equals("workflow_pool")) {
                wi = WorkflowManager.getPooledTasks((Context)this.context, (EPerson)ep);
            }
            if (wi != null) {
                log.debug((Object)("children(): Got " + String.valueOf(wi.size()) + " Workflow Items."));
                DAVResource[] result = new DAVResource[wi.size()];
                ListIterator wii = wi.listIterator();
                int i = 0;
                while (wii.hasNext()) {
                    WorkflowItem wfi = (WorkflowItem)wii.next();
                    result[i++] = new DAVWorkflowItem(this.context, this.request, this.response, this.makeChildPath(DAVWorkflowItem.getPathElt(wfi.getID())), (InProgressSubmission)wfi);
                }
                return result;
            }
        }
        return new DAVResource[0];
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (!this.elementsEqualIsh(property, displaynameProperty)) {
            return this.commonPropfindInternal(property, true);
        }
        value = this.pathElt[0];
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVWorkflow.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for workflow.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for workflow.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for workflow.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for Workflow.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Workflow.");
    }
}

