/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVInProgressSubmission;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.jdom.Element;

class DAVWorkflowItem
extends DAVInProgressSubmission {
    private static Logger log = Logger.getLogger(DAVWorkflowItem.class);
    private static final Element ownerProperty = new Element("owner", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(inProgressProps);

    protected DAVWorkflowItem(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, InProgressSubmission wi) {
        super(context, request, response, pathElt, wi);
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected Element typeValue() {
        return new Element("workflow-item", DAV.NS_DSPACE);
    }

    protected static String getPathElt(int dbid) {
        return "wfi_db_" + String.valueOf(dbid);
    }

    protected static String getPathElt(WorkflowItem wfi) {
        return DAVWorkflowItem.getPathElt(wfi.getID());
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        try {
            if (pathElt.length >= 2 && pathElt[0].startsWith("workflow_") && pathElt[1].startsWith("wfi_db_")) {
                if (pathElt.length >= 3) {
                    DAVResource result = DAVItem.matchResourceURI(context, request, response, pathElt);
                    if (result == null) {
                        throw new DAVStatusException(404, "Invalid resource path.");
                    }
                    return result;
                }
                int id = Integer.parseInt(pathElt[1].substring(7));
                WorkflowItem ips = WorkflowItem.find((Context)context, (int)id);
                if (ips == null) {
                    log.warn((Object)("invalid WorkflowItem DB ID in DAV URI, id=" + pathElt[1]));
                    throw new DAVStatusException(404, "Not found: " + pathElt[1] + " does not exist.");
                }
                return new DAVWorkflowItem(context, request, response, pathElt, (InProgressSubmission)ips);
            }
            return null;
        }
        catch (NumberFormatException ne) {
            throw new DAVStatusException(400, "Error parsing number in request URI.", ne);
        }
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        Element result = super.propfindInternal(property);
        if (result != null) {
            return result;
        }
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = DAVWorkflowItem.getPathElt(this.inProgressItem.getID());
        } else if (this.elementsEqualIsh(property, ownerProperty)) {
            EPerson ep = ((WorkflowItem)this.inProgressItem).getOwner();
            if (ep != null) {
                value = this.hrefToEPerson(ep);
            }
        } else if (this.elementsEqualIsh(property, stateProperty)) {
            value = WorkflowManager.getWorkflowText((int)((WorkflowItem)this.inProgressItem).getState());
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVWorkflowItem.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        if (super.proppatchInternal(action, prop) == 200) {
            return 200;
        }
        if (this.elementsEqualIsh(prop, stateProperty)) {
            if (action == 2) {
                throw new DAVStatusException(409, "The state property cannot be removed.");
            }
            String key = prop.getTextTrim();
            if (key.equalsIgnoreCase("abort")) {
                WorkflowManager.abort((Context)this.context, (WorkflowItem)((WorkflowItem)this.inProgressItem), (EPerson)this.inProgressItem.getSubmitter());
            } else if (key.equalsIgnoreCase("reject")) {
                EPerson cu = this.context.getCurrentUser();
                String who = cu == null ? "nobody" : cu.getFullName();
                WorkflowManager.reject((Context)this.context, (WorkflowItem)((WorkflowItem)this.inProgressItem), (EPerson)this.inProgressItem.getSubmitter(), (String)("Rejected by " + who + ", via WebDAV Network Interface"));
            } else if (key.equalsIgnoreCase("advance")) {
                WorkflowManager.advance((Context)this.context, (WorkflowItem)((WorkflowItem)this.inProgressItem), (EPerson)this.context.getCurrentUser());
            } else if (key.equalsIgnoreCase("claim")) {
                WorkflowManager.claim((Context)this.context, (WorkflowItem)((WorkflowItem)this.inProgressItem), (EPerson)this.context.getCurrentUser());
            } else if (key.equalsIgnoreCase("unclaim")) {
                WorkflowManager.unclaim((Context)this.context, (WorkflowItem)((WorkflowItem)this.inProgressItem), (EPerson)this.context.getCurrentUser());
            } else {
                int newState = WorkflowManager.getWorkflowID((String)key);
                if (newState >= 0) {
                    ((WorkflowItem)this.inProgressItem).setState(newState);
                } else {
                    throw new DAVStatusException(409, "Unrecognized verb or state-name in value for state property.");
                }
            }
            this.inProgressItem.update();
            return 200;
        }
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    static {
        allProps.add(ownerProperty);
        allProps.add(stateProperty);
    }
}

