/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.app.dav.DAVWorkspaceItem;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Element;

class DAVWorkspace
extends DAVResource {
    private static Logger log = Logger.getLogger(DAVWorkspace.class);
    private static List<Element> allProps = new ArrayList<Element>(commonProps);

    @Override
    protected Element typeValue() {
        return new Element("workspace", DAV.NS_DSPACE);
    }

    protected DAVWorkspace(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) {
        super(context, request, response, pathElt);
        this.type = 32;
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        if (pathElt.length > 0 && pathElt[0].equals("workspace")) {
            if (pathElt.length > 1) {
                return DAVWorkspaceItem.matchResourceURI(context, request, response, pathElt);
            }
            return new DAVWorkspace(context, request, response, pathElt);
        }
        return null;
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected DAVResource[] children() throws SQLException {
        EPerson ep = this.context.getCurrentUser();
        if (ep != null) {
            WorkspaceItem[] wi = WorkspaceItem.findByEPerson((Context)this.context, (EPerson)ep);
            log.debug((Object)("children(): Got " + String.valueOf(wi.length) + " Workspace Items."));
            DAVResource[] result = new DAVResource[wi.length];
            for (int i = 0; i < wi.length; ++i) {
                result[i] = new DAVWorkspaceItem(this.context, this.request, this.response, this.makeChildPath(DAVWorkspaceItem.getPathElt(wi[i].getID())), (InProgressSubmission)wi[i]);
            }
            return result;
        }
        return new DAVResource[0];
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (!this.elementsEqualIsh(property, displaynameProperty)) {
            return this.commonPropfindInternal(property, true);
        }
        value = "workspace";
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVWorkspace.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
    }

    @Override
    protected void get() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "GET method not implemented for workspace.");
    }

    @Override
    protected void put() throws SQLException, AuthorizeException, IOException, DAVStatusException {
        throw new DAVStatusException(501, "PUT method not implemented for workspace.");
    }

    @Override
    protected int copyInternal(DAVResource destination, int depth, boolean overwrite, boolean keepProperties) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "COPY method not implemented for workspace.");
    }

    @Override
    protected int deleteInternal() throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(501, "DELETE method not implemented for Workspace.");
    }

    @Override
    protected int mkcolInternal(String waste) throws DAVStatusException, SQLException, AuthorizeException, IOException {
        throw new DAVStatusException(405, "MKCOL method not allowed for Workspace.");
    }
}

