/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAV;
import org.dspace.app.dav.DAVInProgressSubmission;
import org.dspace.app.dav.DAVItem;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowManager;
import org.jdom.Element;

class DAVWorkspaceItem
extends DAVInProgressSubmission {
    private static Logger log = Logger.getLogger(DAVWorkspaceItem.class);
    private static final Element stage_reachedProperty = new Element("stage_reached", DAV.NS_DSPACE);
    private static List<Element> allProps = new ArrayList<Element>(inProgressProps);

    protected DAVWorkspaceItem(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt, InProgressSubmission wi) {
        super(context, request, response, pathElt, wi);
    }

    @Override
    protected List<Element> getAllProperties() {
        return allProps;
    }

    @Override
    protected Element typeValue() {
        return new Element("workspace-item", DAV.NS_DSPACE);
    }

    protected static String getPathElt(int dbid) {
        return "wsi_db_" + String.valueOf(dbid);
    }

    protected static DAVResource matchResourceURI(Context context, HttpServletRequest request, HttpServletResponse response, String[] pathElt) throws DAVStatusException, SQLException {
        try {
            if (pathElt.length >= 2 && pathElt[0].equals("workspace") && pathElt[1].startsWith("wsi_db_")) {
                if (pathElt.length >= 3) {
                    DAVResource result = DAVItem.matchResourceURI(context, request, response, pathElt);
                    if (result == null) {
                        throw new DAVStatusException(404, "Invalid resource path.");
                    }
                    return result;
                }
                int id = Integer.parseInt(pathElt[1].substring(7));
                WorkspaceItem ips = WorkspaceItem.find((Context)context, (int)id);
                if (ips == null) {
                    log.warn((Object)("invalid WorkspaceItem DB ID in DAV URI, id=" + pathElt[1]));
                    throw new DAVStatusException(404, "Not found: " + pathElt[1] + " does not exist.");
                }
                return new DAVWorkspaceItem(context, request, response, pathElt, (InProgressSubmission)ips);
            }
            return null;
        }
        catch (NumberFormatException ne) {
            throw new DAVStatusException(400, "Error parsing number in request URI.", ne);
        }
    }

    @Override
    protected Element propfindInternal(Element property) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        String value = null;
        if (this.elementsEqualIsh(property, displaynameProperty)) {
            value = DAVWorkspaceItem.getPathElt(this.inProgressItem.getID());
        } else if (this.elementsEqualIsh(property, stage_reachedProperty)) {
            value = String.valueOf(((WorkspaceItem)this.inProgressItem).getStageReached());
        } else {
            return super.propfindInternal(property);
        }
        if (value == null) {
            throw new DAVStatusException(404, "Not found.");
        }
        Element p = new Element(property.getName(), property.getNamespace());
        p.setText(DAVWorkspaceItem.filterForXML(value));
        return p;
    }

    @Override
    protected int proppatchInternal(int action, Element prop) throws SQLException, AuthorizeException, IOException, DAVStatusException {
        if (super.proppatchInternal(action, prop) == 200) {
            return 200;
        }
        if (this.elementsEqualIsh(prop, stateProperty)) {
            if (action == 2) {
                throw new DAVStatusException(409, "The state property cannot be removed.");
            }
            String key = prop.getTextTrim();
            if (key.equalsIgnoreCase("start")) {
                WorkflowManager.start((Context)this.context, (WorkspaceItem)((WorkspaceItem)this.inProgressItem));
            } else if (key.equalsIgnoreCase("start_without_notify")) {
                WorkflowManager.startWithoutNotify((Context)this.context, (WorkspaceItem)((WorkspaceItem)this.inProgressItem));
            }
        } else if (this.elementsEqualIsh(prop, stage_reachedProperty)) {
            if (action == 2) {
                throw new DAVStatusException(409, "The stage property cannot be removed.");
            }
            try {
                ((WorkspaceItem)this.inProgressItem).setStageReached(Integer.parseInt(prop.getTextTrim()));
            }
            catch (NumberFormatException ne) {
                throw new DAVStatusException(400, "Error parsing number in property value.", ne);
            }
        } else {
            throw new DAVStatusException(409, "The " + prop.getName() + " property cannot be changed.");
        }
        this.inProgressItem.update();
        return 200;
    }

    static {
        allProps.add(stage_reachedProperty);
    }
}

