/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.log4j.Logger;
import org.dspace.app.dav.DAVLookup;
import org.dspace.app.dav.DAVResource;
import org.dspace.app.dav.DAVServlet;
import org.dspace.app.dav.DAVStatusException;
import org.dspace.app.dav.LNIRemoteException;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LNISoapServlet
extends AxisServlet {
    private static Logger log = Logger.getLogger(LNISoapServlet.class);
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private static String[] lookupPathElt = new String[]{"lookup", "handle"};

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DAVServlet.serviceInternal("GET", request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DAVServlet.serviceInternal("PUT", request, response);
    }

    private Context prologue() throws SQLException, IOException {
        MessageContext mc = MessageContext.getCurrentContext();
        String username = null;
        String password = null;
        if (mc.getUsername() != null) {
            username = DAVServlet.decodeFromURL(mc.getUsername());
        }
        if (mc.getPassword() != null) {
            password = DAVServlet.decodeFromURL(mc.getPassword());
        }
        this.request = (HttpServletRequest)mc.getProperty("transport.http.servletRequest");
        this.response = (HttpServletResponse)mc.getProperty("transport.http.servletResponse");
        Context context = new Context();
        if (DAVServlet.getAuthFromCookie(context, this.request)) {
            DAVServlet.putAuthCookie(context, this.request, this.response, false);
            log.debug((Object)("SOAP service " + ((Object)((Object)this)).getClass().getName() + " authenticated with cookie."));
            return context;
        }
        int status = AuthenticationManager.authenticate((Context)context, (String)username, (String)password, null, (HttpServletRequest)this.request);
        if (status == 1) {
            EPerson cu = context.getCurrentUser();
            log.debug((Object)("SOAP service " + ((Object)((Object)this)).getClass().getName() + " authenticated as " + cu.getEmail() + " (" + cu.getFirstName() + " " + cu.getLastName() + ")"));
            DAVServlet.putAuthCookie(context, this.request, this.response, true);
            return context;
        }
        if (status == 2) {
            context.abort();
            throw new LNIRemoteException("Authentication failed: Bad Credentials.");
        }
        if (status == 3) {
            context.abort();
            throw new LNIRemoteException("Authentication failed: This user may only login with X.509 certificate.");
        }
        if (status == 4) {
            context.abort();
            throw new LNIRemoteException("Authentication failed: No such user.");
        }
        context.abort();
        throw new LNIRemoteException("Authentication failed: Cannot authenticate.");
    }

    public String propfind(String uri, String doc, int depth, String types) throws LNIRemoteException {
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        String[] pathElt = uri.split("/");
        Context context = null;
        try {
            context = this.prologue();
            String[] aTypes = types == null ? null : types.split(",");
            int typeMask = DAVResource.typesToMask(aTypes);
            DAVResource resource = DAVResource.findResource(context, null, null, pathElt);
            if (resource == null) {
                throw new LNIRemoteException("Resource not found.");
            }
            Document outdoc = resource.propfindDriver(depth, new ByteArrayInputStream(doc.getBytes()), typeMask);
            if (outdoc == null) {
                throw new LNIRemoteException("propfind failed, no document returned.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            outputPretty.output(outdoc, (OutputStream)baos);
            context.complete();
            String string = baos.toString();
            return string;
        }
        catch (IOException ie) {
            throw new LNIRemoteException("Exception executing PROPFIND", ie);
        }
        catch (SQLException e) {
            throw new LNIRemoteException("Failure accessing database", e);
        }
        catch (DAVStatusException e) {
            throw new LNIRemoteException("PROPFIND request failed: " + e.getStatusLine(), e);
        }
        catch (AuthorizeException e) {
            throw new LNIRemoteException("You are not authorized for the requested operation.", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public String proppatch(String uri, String doc) throws LNIRemoteException {
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        String[] pathElt = uri.split("/");
        Context context = null;
        try {
            context = this.prologue();
            DAVResource resource = DAVResource.findResource(context, null, null, pathElt);
            if (resource == null) {
                throw new LNIRemoteException("Resource not found.");
            }
            Document outdoc = resource.proppatchDriver(new ByteArrayInputStream(doc.getBytes()));
            if (outdoc == null) {
                throw new LNIRemoteException("proppatch failed, no document returned.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            outputPretty.output(outdoc, (OutputStream)baos);
            context.complete();
            String string = baos.toString();
            return string;
        }
        catch (IOException ie) {
            throw new LNIRemoteException("Exception executing PROPPATCH", ie);
        }
        catch (SQLException e) {
            throw new LNIRemoteException("Failure accessing database", e);
        }
        catch (DAVStatusException e) {
            throw new LNIRemoteException("PROPPATCH request failed: " + e.getStatusLine(), e);
        }
        catch (AuthorizeException e) {
            throw new LNIRemoteException("You are not authorized for the requested operation.", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public String lookup(String handle, String bitstreamPid) throws LNIRemoteException {
        Context context = null;
        try {
            DAVLookup resource;
            String result;
            context = this.prologue();
            if (handle.startsWith("hdl:")) {
                handle = handle.substring(4);
            }
            if ((result = (resource = new DAVLookup(context, this.request, this.response, lookupPathElt)).makeURI(handle, bitstreamPid)) == null) {
                throw new LNIRemoteException("Resource not found.");
            }
            context.complete();
            String string = result;
            return string;
        }
        catch (IOException ie) {
            throw new LNIRemoteException("Exception executing LOOKUP", ie);
        }
        catch (SQLException e) {
            throw new LNIRemoteException("Failure accessing database", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public int copy(String source, String destination, int depth, boolean overwrite, boolean keepProperties) throws LNIRemoteException {
        if (source.startsWith("/")) {
            source = source.substring(1);
        }
        String[] pathElt = source.split("/");
        Context context = null;
        try {
            context = this.prologue();
            DAVResource resource = DAVResource.findResource(context, null, null, pathElt);
            if (resource == null) {
                throw new LNIRemoteException("Resource not found.");
            }
            int status = resource.copyDriver(destination, depth, overwrite, keepProperties);
            context.complete();
            int n = status;
            return n;
        }
        catch (IOException ie) {
            throw new LNIRemoteException("IOException while executing COPY", ie);
        }
        catch (SQLException e) {
            throw new LNIRemoteException("Failure accessing database", e);
        }
        catch (DAVStatusException e) {
            throw new LNIRemoteException("COPY request failed: " + e.getStatusLine(), e);
        }
        catch (AuthorizeException e) {
            throw new LNIRemoteException("You are not authorized for the requested operation.", e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }
}

