/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;
import org.dspace.search.Harvest;
import org.dspace.search.HarvestedItemInfo;

public class DSpaceOAICatalog
extends AbstractCatalog {
    private static Logger log = Logger.getLogger(DSpaceOAICatalog.class);
    public static final String OAI_ID_PREFIX = "oai:" + ConfigurationManager.getProperty((String)"dspace.hostname") + ":";
    private final int MAX_RECORDS = 100;

    public DSpaceOAICatalog(Properties properties) {
    }

    public Vector getSchemaLocations(String identifier) throws OAIInternalServerError, IdDoesNotExistException, NoMetadataFormatsException {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)("verb=getSchemaLocations,identifier=" + (identifier == null ? "null" : identifier))));
        HarvestedItemInfo itemInfo = null;
        Context context = null;
        try {
            context = new Context();
            if (identifier.startsWith(OAI_ID_PREFIX)) {
                itemInfo = Harvest.getSingle((Context)context, (String)identifier.substring(OAI_ID_PREFIX.length()), (boolean)false);
            }
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)""), (Throwable)se);
            throw new OAIInternalServerError(se.toString());
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        if (itemInfo == null) {
            throw new IdDoesNotExistException(identifier);
        }
        if (itemInfo.withdrawn) {
            throw new NoMetadataFormatsException();
        }
        return this.getRecordFactory().getSchemaLocations((Object)itemInfo);
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws OAIInternalServerError, NoSetHierarchyException, NoItemsMatchException, CannotDisseminateFormatException, BadArgumentException {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)("verb=listIdentifiers,from=" + (from == null ? "null" : from) + ",until=" + (until == null ? "null" : until) + ",set=" + (set == null ? "null" : set) + ",metadataPrefix=" + (metadataPrefix == null ? "null" : metadataPrefix))));
        Context context = null;
        LinkedList<String> headers = new LinkedList<String>();
        LinkedList<String> identifiers = new LinkedList<String>();
        try {
            context = new Context();
            DSpaceObject scope = this.resolveSet(context, set);
            List itemInfos = Harvest.harvest((Context)context, (DSpaceObject)scope, (String)from, (String)until, (int)0, (int)0, (boolean)false, (boolean)true, (boolean)true);
            if (itemInfos.size() == 0) {
                log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"no_items_match"));
                throw new NoItemsMatchException();
            }
            for (HarvestedItemInfo itemInfo : itemInfos) {
                String[] header = this.getRecordFactory().createHeader((Object)itemInfo);
                headers.add(header[0]);
                identifiers.add(header[1]);
            }
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)""), (Throwable)se);
            throw new OAIInternalServerError(se.toString());
        }
        catch (ParseException pe) {
            throw new OAIInternalServerError(pe.toString());
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        HashMap results = new HashMap();
        results.put("headers", headers.iterator());
        results.put("identifiers", identifiers.iterator());
        return results;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        throw new BadResumptionTokenException();
    }

    public String getRecord(String identifier, String metadataPrefix) throws OAIInternalServerError, CannotDisseminateFormatException, IdDoesNotExistException {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)("verb=getRecord,identifier=" + (identifier == null ? "null" : identifier) + ",metadataPrefix=" + (metadataPrefix == null ? "null" : metadataPrefix))));
        Context context = null;
        String record = null;
        HarvestedItemInfo itemInfo = null;
        try {
            if (identifier.startsWith(OAI_ID_PREFIX)) {
                context = new Context();
                itemInfo = Harvest.getSingle((Context)context, (String)identifier.substring(OAI_ID_PREFIX.length()), (boolean)true);
            }
            if (itemInfo == null) {
                log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"id_does_not_exist"));
                throw new IdDoesNotExistException(identifier);
            }
            String schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix);
            if (schemaURL == null) {
                log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"cannot_disseminate_format"));
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            record = this.getRecordFactory().create((Object)itemInfo, schemaURL, metadataPrefix);
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)""), (Throwable)se);
            throw new OAIInternalServerError(se.toString());
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        return record;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws OAIInternalServerError, NoSetHierarchyException, CannotDisseminateFormatException, NoItemsMatchException, BadArgumentException {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)("verb=listRecords,from=" + (from == null ? "null" : from) + ",until=" + (until == null ? "null" : until) + ",set=" + (set == null ? "null" : set) + ",metadataPrefix=" + (metadataPrefix == null ? "null" : metadataPrefix))));
        Map m = this.doRecordHarvest(from, until, set, metadataPrefix, 0);
        if (m == null) {
            log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"cannot_disseminate_format"));
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        Iterator i = (Iterator)m.get("records");
        if (i == null || !i.hasNext()) {
            log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"no_items_match"));
            throw new NoItemsMatchException();
        }
        return m;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)("verb=listRecords,resumptionToken=" + resumptionToken)));
        Object[] params = this.decodeResumptionToken(resumptionToken);
        Integer offset = (Integer)params[4];
        Map m = null;
        try {
            m = this.doRecordHarvest((String)params[0], (String)params[1], (String)params[2], (String)params[3], offset);
        }
        catch (BadArgumentException bae) {
            m = null;
        }
        if (m == null) {
            log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)"bad_resumption_token"));
            throw new BadResumptionTokenException();
        }
        return m;
    }

    private Map doRecordHarvest(String from, String until, String set, String metadataPrefix, int offset) throws OAIInternalServerError, BadArgumentException {
        Context context = null;
        String schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (schemaURL == null) {
            return null;
        }
        LinkedList<String> records = new LinkedList<String>();
        try {
            context = new Context();
            DSpaceObject scope = this.resolveSet(context, set);
            List itemInfos = Harvest.harvest((Context)context, (DSpaceObject)scope, (String)from, (String)until, (int)offset, (int)100, (boolean)true, (boolean)true, (boolean)true);
            for (HarvestedItemInfo itemInfo : itemInfos) {
                try {
                    String recordXML = this.getRecordFactory().create((Object)itemInfo, schemaURL, metadataPrefix);
                    records.add(recordXML);
                }
                catch (CannotDisseminateFormatException cdfe) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"oai_warning", (String)("Couldn't disseminate " + metadataPrefix + " for " + itemInfo.handle)));
                }
            }
            results.put("records", records.iterator());
            log.info((Object)LogManager.getHeader((Context)context, (String)"oai_harvest", (String)("results=" + records.size())));
            if (records.size() >= 100) {
                String resumptionToken = this.makeResumptionToken(from, until, set, metadataPrefix, offset + 100);
                if (log.isDebugEnabled()) {
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"made_resumption_token", (String)("token=" + resumptionToken)));
                }
                results.put("resumptionMap", this.getResumptionMap(resumptionToken));
            }
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)""), (Throwable)se);
            throw new OAIInternalServerError(se.toString());
        }
        catch (ParseException pe) {
            throw new OAIInternalServerError(pe.toString());
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        return results;
    }

    public Map listSets() throws NoSetHierarchyException, OAIInternalServerError {
        log.info((Object)LogManager.getHeader(null, (String)"oai_request", (String)"verb=listSets"));
        Context context = null;
        LinkedList<String> sets = new LinkedList<String>();
        try {
            context = new Context();
            Collection[] allCols = Collection.findAll((Context)context);
            StringBuffer spec = null;
            for (int i = 0; i < allCols.length; ++i) {
                spec = new StringBuffer("<set><setSpec>hdl_");
                spec.append(allCols[i].getHandle().replace('/', '_'));
                spec.append("</setSpec>");
                String collName = allCols[i].getMetadata("name");
                if (collName != null) {
                    spec.append("<setName>");
                    spec.append(Utils.addEntities((String)collName));
                    spec.append("</setName>");
                } else {
                    spec.append("<setName />");
                    log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)("null_set_name_for_set_id_" + allCols[i].getHandle())));
                }
                spec.append("</set>");
                sets.add(spec.toString());
            }
            Community[] allComs = Community.findAll((Context)context);
            for (int i = 0; i < allComs.length; ++i) {
                spec = new StringBuffer("<set><setSpec>hdl_");
                spec.append(allComs[i].getHandle().replace('/', '_'));
                spec.append("</setSpec>");
                String commName = allComs[i].getMetadata("name");
                if (commName != null) {
                    spec.append("<setName>");
                    spec.append(Utils.addEntities((String)commName));
                    spec.append("</setName>");
                } else {
                    spec.append("<setName />");
                    log.info((Object)LogManager.getHeader(null, (String)"oai_error", (String)("null_set_name_for_set_id_" + allComs[i].getHandle())));
                }
                spec.append("</set>");
                sets.add(spec.toString());
            }
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)""), (Throwable)se);
            throw new OAIInternalServerError(se.toString());
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
        HashMap results = new HashMap();
        results.put("sets", sets.iterator());
        return results;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        throw new BadResumptionTokenException();
    }

    public void close() {
    }

    private DSpaceObject resolveSet(Context context, String set) throws SQLException, BadArgumentException {
        if (set == null) {
            return null;
        }
        DSpaceObject o = null;
        if (set.startsWith("hdl_")) {
            String handle = set.substring(4).replace('_', '/');
            o = HandleManager.resolveToObject((Context)context, (String)handle);
        }
        if (o != null && (o instanceof Collection || o instanceof Community)) {
            return o;
        }
        throw new BadArgumentException();
    }

    private String makeResumptionToken(String from, String until, String set, String prefix, int offset) {
        StringBuffer token = new StringBuffer();
        if (from != null) {
            token.append(from);
        }
        token.append("/");
        if (until != null) {
            token.append(until);
        }
        token.append("/");
        if (set != null) {
            token.append(set);
        }
        token.append("/");
        if (prefix != null) {
            token.append(prefix);
        }
        token.append("/");
        token.append(String.valueOf(offset));
        return token.toString();
    }

    private Object[] decodeResumptionToken(String token) throws BadResumptionTokenException {
        Object[] obj = new Object[5];
        StringTokenizer st = new StringTokenizer(token, "/", true);
        try {
            for (int i = 0; i < 4; ++i) {
                if (!st.hasMoreTokens()) {
                    throw new BadResumptionTokenException();
                }
                String s = st.nextToken();
                if (s.equals("/")) {
                    obj[i] = null;
                } else {
                    obj[i] = s;
                    st.nextToken();
                }
                log.debug((Object)("is: " + (String)obj[i]));
            }
            if (!st.hasMoreTokens()) {
                throw new BadResumptionTokenException();
            }
            obj[4] = new Integer(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new BadResumptionTokenException();
        }
        catch (NoSuchElementException nsee) {
            throw new BadResumptionTokenException();
        }
        return obj;
    }
}

