/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.search.HarvestedItemInfo;

public class OAIDCCrosswalk
extends Crosswalk {
    private static final Pattern invalidXmlPattern = Pattern.compile("([^\\t\\n\\r\\u0020-\\ud7ff\\ue000-\\ufffd\\u10000-\\u10ffff]+|[&<>])");
    private static final Pattern dcElementPattern = Pattern.compile("(^(title|creator|subject|description|publisher|contributor|date|type|format|identifier|source|language|relation|coverage|rights)$)");

    public OAIDCCrosswalk(Properties properties) {
        super("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        Item item = ((HarvestedItemInfo)nativeItem).item;
        DCValue[] allDC = item.getDC("*", "*", "*");
        StringBuffer metadata = new StringBuffer();
        metadata.append("<oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" ").append("xmlns:dc=\"http://purl.org/dc/elements/1.1/\" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\">");
        for (int i = 0; i < allDC.length; ++i) {
            String value;
            boolean provenance;
            String element = allDC[i].element;
            String qualifier = allDC[i].qualifier;
            boolean bl = provenance = "description".equals(element) && "provenance".equals(qualifier);
            if (!dcElementPattern.matcher(element).matches() || provenance) continue;
            if ("contributor".equals(element) && "author".equals(qualifier)) {
                element = "creator";
            }
            if ((value = allDC[i].value) == null) continue;
            StringBuffer valueBuf = new StringBuffer(value.length());
            Matcher xmlMatcher = invalidXmlPattern.matcher(value.trim());
            while (xmlMatcher.find()) {
                String group = xmlMatcher.group();
                if (group.equals("&")) {
                    xmlMatcher.appendReplacement(valueBuf, "&amp;");
                    continue;
                }
                if (group.equals("<")) {
                    xmlMatcher.appendReplacement(valueBuf, "&lt;");
                    continue;
                }
                if (group.equals(">")) {
                    xmlMatcher.appendReplacement(valueBuf, "&gt;");
                    continue;
                }
                xmlMatcher.appendReplacement(valueBuf, " ");
            }
            xmlMatcher.appendTail(valueBuf);
            metadata.append("<dc:").append(element).append(">").append(valueBuf.toString()).append("</dc:").append(element).append(">");
        }
        metadata.append("</oai_dc:dc>");
        return metadata.toString();
    }
}

